/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.giop;

import gnu.CORBA.IOR;
import gnu.CORBA.NamingService.NameTransformer;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.java.lang.CPStringBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class CorbalocParser
extends NameTransformer {
    public static final String pxCORBALOC = "corbaloc";
    public static final String pxCORBANAME = "corbaname";
    public static final String pxIOR = "ior";
    public static final String pxFILE = "file://";
    public static final String pxFTP = "ftp://";
    public static final String pxHTTP = "http://";
    public static final String IIOP = "iiop";
    public static final String RIR = "rir";
    public static final int DEFAULT_PORT = 2809;
    public static final String DEFAULT_NAME = "NameService";
    static NameTransformer converter;
    int p;
    String[] t;

    public synchronized String[] corbaloc(String string, ORB oRB) throws InvalidNameException {
        return this.corbaloc(string, oRB, 0);
    }

    private String[] corbaloc(String string, ORB oRB, int n) throws InvalidNameException {
        if (n > 10) {
            throw new DATA_CONVERSION("More than 10 redirections");
        }
        if (string.startsWith(pxFILE)) {
            return this.corbaloc(this.readFile(string.substring(pxFILE.length())), oRB, n + 1);
        }
        if (string.startsWith(pxHTTP)) {
            return this.corbaloc(this.readUrl(string), oRB, n + 1);
        }
        if (string.startsWith(pxFTP)) {
            return this.corbaloc(this.readUrl(string), oRB, n + 1);
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = 2809;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":@/.,#", true);
        this.t = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < this.t.length; ++i) {
            this.t[i] = stringTokenizer.nextToken();
        }
        this.p = 0;
        if (!this.t[this.p].startsWith(pxCORBANAME)) {
            throw new InvalidNameException(string + " must start with " + pxCORBANAME);
        }
        ++this.p;
        if (!this.t[this.p++].equals(":")) {
            throw new BAD_PARAM("Syntax (':' expected after name prefix)");
        }
        if (this.t[this.p].equals(RIR)) {
            ++this.p;
            if (!this.t[this.p++].equals(":")) {
                throw new BAD_PARAM("':' expected after 'rir'");
            }
            String string2 = this.readKey("/");
            try {
                Object object = oRB.resolve_initial_references(string2);
                return this.resolve(oRB.object_to_string(object));
            }
            catch (InvalidName invalidName) {
                throw new BAD_PARAM("Unknown initial reference '" + string2 + "'");
            }
        }
        if (this.t[this.p].equals(IIOP) || this.t[this.p].equals(":")) {
            IOR iOR = new IOR();
            while (true) {
                String string3;
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                } else {
                    ++this.p;
                    if (!this.t[this.p++].equals(":")) {
                        throw new BAD_PARAM("':' expected after 'iiop'");
                    }
                    if (this.t[this.p + 1].equals(".") && this.t[this.p + 3].equals("@")) {
                        try {
                            n2 = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + "'");
                        }
                        ++this.p;
                        try {
                            n3 = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + "'");
                        }
                        ++this.p;
                    }
                }
                iOR.Internet.version = new Version(n2, n3);
                CPStringBuilder cPStringBuilder = new CPStringBuilder(string.length());
                while (!(this.t[this.p].equals(":") || this.t[this.p].equals("/") || this.t[this.p].equals(","))) {
                    cPStringBuilder.append(this.t[this.p++]);
                }
                iOR.Internet.host = string3 = cPStringBuilder.toString();
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                    try {
                        n4 = Integer.parseInt(this.t[this.p++]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BAD_PARAM("Invalid port '" + this.t[this.p - 1] + "'");
                    }
                }
                iOR.Internet.port = n4;
                iOR.Id = "";
                if (!this.t[this.p].equals(",")) break;
                ++this.p;
            }
            String string4 = this.readKey("/");
            iOR.key = string4.getBytes();
            return this.resolve(iOR.toStringifiedReference());
        }
        throw new InvalidNameException("Unsupported protocol '" + this.t[this.p] + "' (iiop expected)");
    }

    String readFile(String string) {
        java.lang.Object object;
        File file = new File(string);
        if (!file.exists()) {
            object = new DATA_CONVERSION(file.getAbsolutePath() + " does not exist.");
            object.minor = 1195573270;
        }
        try {
            object = new char[(int)file.length()];
            FileReader fileReader = new FileReader(file);
            fileReader.read((char[])object);
            fileReader.close();
            return new String((char[])object).trim();
        }
        catch (IOException iOException) {
            DATA_CONVERSION dATA_CONVERSION = new DATA_CONVERSION();
            dATA_CONVERSION.initCause(iOException);
            dATA_CONVERSION.minor = 1195573270;
            throw dATA_CONVERSION;
        }
    }

    String readUrl(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BAD_PARAM("Malformed URL: '" + string + "'");
        }
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            while ((n = inputStreamReader.read()) > 0) {
                cPStringBuilder.append((char)n);
            }
            return cPStringBuilder.toString().trim();
        }
        catch (Exception exception) {
            DATA_CONVERSION dATA_CONVERSION = new DATA_CONVERSION("Reading " + string + " failed.");
            dATA_CONVERSION.minor = 1195573270;
            throw dATA_CONVERSION;
        }
    }

    private String[] resolve(String string) {
        String[] stringArray = new String[]{string, this.readKey("#")};
        return stringArray;
    }

    private String readKey(String string) throws BAD_PARAM {
        if (this.p < this.t.length && !this.t[this.p].equals(string)) {
            if (this.t[this.p].equals("#")) {
                return DEFAULT_NAME;
            }
            throw new BAD_PARAM("'" + string + "String' expected '" + this.t[this.p] + "' found");
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        ++this.p;
        while (this.p < this.t.length && !this.t[this.p].equals("#")) {
            cPStringBuilder.append(this.t[this.p++]);
        }
        if (cPStringBuilder.length() == 0) {
            return DEFAULT_NAME;
        }
        try {
            return URLDecoder.decode(cPStringBuilder.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Unexpected("URLDecoder does not support UTF-8", unsupportedEncodingException);
        }
    }
}

