/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.giop;

import gnu.CORBA.NamingService.Ext;
import gnu.CORBA.NamingService.NameTransformer;
import gnu.javax.naming.giop.GiopNamingServiceFactory;
import gnu.javax.naming.giop.ListBindingsEnumeration;
import gnu.javax.naming.giop.ListEnumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming._NamingContextExtStub;
import org.omg.CosNaming._NamingContextStub;

public class ContextContinuation
implements Context {
    public int DEFAULT_BATCH_SIZE = 20;
    NamingContextExt service;
    ORB orb;
    Hashtable properties;
    GiopNamingServiceFactory factory;
    static NameTransformer transformer = new NameTransformer();
    public final int howMany;

    public ContextContinuation(Object object, Hashtable hashtable, ORB oRB, GiopNamingServiceFactory giopNamingServiceFactory) {
        this.factory = giopNamingServiceFactory;
        this.orb = oRB;
        Delegate delegate = ((ObjectImpl)object)._get_delegate();
        if (!object._is_a(NamingContextExtHelper.id()) && object._is_a(NamingContextHelper.id())) {
            _NamingContextStub _NamingContextStub2 = new _NamingContextStub();
            _NamingContextStub2._set_delegate(delegate);
            this.service = new Ext(_NamingContextStub2);
        } else {
            _NamingContextExtStub _NamingContextExtStub2 = new _NamingContextExtStub();
            _NamingContextExtStub2._set_delegate(delegate);
            this.service = _NamingContextExtStub2;
        }
        this.properties = hashtable;
        this.howMany = this.getBatchSize();
    }

    public void bind(Name name, java.lang.Object object) throws NamingException {
        try {
            Object object2 = (Object)object;
            this.service.bind(this.toGiop(name), object2);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException(Object.class + " required ");
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (AlreadyBound alreadyBound) {
            throw new NameAlreadyBoundException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public void bind(String string, java.lang.Object object) throws NamingException {
        try {
            Object object2 = (Object)object;
            this.service.bind(transformer.toName(string), object2);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException(Object.class + " required ");
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (AlreadyBound alreadyBound) {
            throw new NameAlreadyBoundException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public void close() throws NamingException {
        if (this.orb != null && this.factory != null) {
            this.factory.checkIfReferenced(this.orb);
        }
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        try {
            NamingContext namingContext = this.service.bind_new_context(this.toGiop(name));
            Hashtable hashtable = new Hashtable();
            hashtable.putAll(this.properties);
            return new ContextContinuation(namingContext, hashtable, null, null);
        }
        catch (AlreadyBound alreadyBound) {
            throw new NameAlreadyBoundException();
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public Context createSubcontext(String string) throws NamingException {
        try {
            NamingContext namingContext = this.service.bind_new_context(transformer.toName(string));
            Hashtable hashtable = new Hashtable();
            hashtable.putAll(this.properties);
            return new ContextContinuation(namingContext, hashtable, null, null);
        }
        catch (AlreadyBound alreadyBound) {
            throw new NameAlreadyBoundException(string);
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException(string);
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.unbind(name);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.unbind(string);
    }

    public String getNameInNamespace() throws NamingException {
        if (this.orb != null) {
            return this.orb.object_to_string(this.service);
        }
        try {
            ObjectImpl objectImpl = (ObjectImpl)((java.lang.Object)this.service);
            return objectImpl._orb().object_to_string(objectImpl);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        NamingContext namingContext;
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        BindingListHolder bindingListHolder = new BindingListHolder();
        if (name.size() == 0) {
            namingContext = this.service;
        } else {
            try {
                namingContext = NamingContextHelper.narrow(this.service.resolve(this.toGiop(name)));
            }
            catch (Exception exception) {
                throw new NamingException(exception.toString());
            }
        }
        namingContext.list(this.howMany, bindingListHolder, bindingIteratorHolder);
        return new ListEnumeration(bindingListHolder, bindingIteratorHolder, this.howMany);
    }

    public NamingEnumeration list(String string) throws NamingException {
        NamingContext namingContext;
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        BindingListHolder bindingListHolder = new BindingListHolder();
        if (string.length() == 0) {
            namingContext = this.service;
        } else {
            try {
                namingContext = NamingContextHelper.narrow(this.service.resolve_str(string));
            }
            catch (Exception exception) {
                throw new NamingException(exception.toString());
            }
        }
        namingContext.list(this.howMany, bindingListHolder, bindingIteratorHolder);
        return new ListEnumeration(bindingListHolder, bindingIteratorHolder, this.howMany);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        NamingContext namingContext;
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        BindingListHolder bindingListHolder = new BindingListHolder();
        if (name.size() == 0) {
            namingContext = this.service;
        } else {
            try {
                namingContext = NamingContextHelper.narrow(this.service.resolve(this.toGiop(name)));
            }
            catch (Exception exception) {
                throw new NamingException(exception.toString());
            }
        }
        namingContext.list(this.howMany, bindingListHolder, bindingIteratorHolder);
        return new ListBindingsEnumeration(bindingListHolder, bindingIteratorHolder, this.howMany, namingContext);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        NamingContext namingContext;
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        BindingListHolder bindingListHolder = new BindingListHolder();
        if (string.length() == 0) {
            namingContext = this.service;
        } else {
            try {
                namingContext = NamingContextHelper.narrow(this.service.resolve_str(string));
            }
            catch (Exception exception) {
                throw new NamingException(exception.toString());
            }
        }
        namingContext.list(this.howMany, bindingListHolder, bindingIteratorHolder);
        return new ListBindingsEnumeration(bindingListHolder, bindingIteratorHolder, this.howMany, namingContext);
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        try {
            return this.service.resolve(this.toGiop(name));
        }
        catch (NotFound notFound) {
            throw new NameNotFoundException();
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public java.lang.Object lookup(String string) throws NamingException {
        try {
            return this.service.resolve_str(string);
        }
        catch (NotFound notFound) {
            throw new NameNotFoundException();
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public java.lang.Object lookupLink(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, java.lang.Object object) throws NamingException {
        try {
            Object object2 = (Object)object;
            this.service.rebind(this.toGiop(name), object2);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException(Object.class + " required ");
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public void rebind(String string, java.lang.Object object) throws NamingException {
        try {
            Object object2 = (Object)object;
            this.service.rebind(transformer.toName(string), object2);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException(Object.class + " required ");
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        java.lang.Object object = this.lookup(name);
        this.unbind(name);
        this.bind(name2, object);
    }

    public void rename(String string, String string2) throws NamingException {
        java.lang.Object object = this.lookup(string);
        this.unbind(string);
        this.bind(string2, object);
    }

    public void unbind(Name name) throws NamingException {
        try {
            this.service.unbind(this.toGiop(name));
        }
        catch (NotFound notFound) {
            throw new NameNotFoundException();
        }
        catch (CannotProceed cannotProceed) {
            throw new ContextNotEmptyException();
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
    }

    public void unbind(String string) throws NamingException {
        try {
            this.service.unbind(transformer.toName(string));
        }
        catch (NotFound notFound) {
            throw new NameNotFoundException(string);
        }
        catch (CannotProceed cannotProceed) {
            throw new ContextNotEmptyException(string);
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException(string);
        }
    }

    public java.lang.Object addToEnvironment(String string, java.lang.Object object) throws NamingException {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        return this.properties.put(string, object);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.properties;
    }

    public java.lang.Object removeFromEnvironment(String string) throws NamingException {
        return this.properties.remove(string);
    }

    public NameComponent[] toGiop(Name name) throws InvalidName {
        return transformer.toName(name.toString());
    }

    public int getBatchSize() {
        int n = this.DEFAULT_BATCH_SIZE;
        java.lang.Object v = this.properties.get("java.naming.batchsize");
        if (v != null) {
            try {
                int n2 = Integer.parseInt(v.toString());
                if (n2 >= 0) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

