/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;
import java.util.Date;

public class PNGTime
extends PNGChunk {
    private Date date;

    protected PNGTime(int n, byte[] byArray, int n2) throws PNGException {
        super(n, byArray, n2);
        if (byArray.length < 7) {
            throw new PNGException("Unexpectedly short time chunk. (" + byArray.length + " bytes)");
        }
        int n3 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        int n6 = byArray[4] & 0xFF;
        int n7 = byArray[5] & 0xFF;
        int n8 = byArray[6] & 0xFF;
        this.date = new Date(n3 - 1900, n4 - 1, n5, n6, n7, n8);
    }

    public PNGTime(Date date) {
        super(1950960965);
        this.data = new byte[7];
        int n = date.getYear() + 1900;
        this.data[0] = (byte)((n & 0xFF00) >> 8);
        this.data[1] = (byte)(n & 0xFF);
        this.data[2] = (byte)(date.getMonth() + 1);
        this.data[3] = (byte)date.getDay();
        this.data[4] = (byte)date.getHours();
        this.data[5] = (byte)date.getMinutes();
        this.data[6] = (byte)date.getSeconds();
    }

    public String toString() {
        return "PNG Time chunk: " + this.date;
    }
}

