/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGFilter;
import gnu.javax.imageio.png.PNGHeader;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGDecoder {
    private PNGHeader header;
    private byte[] raster;
    private byte[] scanline;
    private byte[] lastScanline;
    private byte[] filterType;
    private int offset;
    private int length;
    private int currentScanline;
    private final int stride;
    private Inflater inflater;
    private boolean readFilter;
    private int bpp;

    public PNGDecoder(PNGHeader pNGHeader) {
        this.header = pNGHeader;
        this.offset = 0;
        this.inflater = new Inflater();
        this.stride = pNGHeader.getScanlineStride();
        this.length = this.stride * pNGHeader.getHeight();
        this.raster = new byte[this.length];
        this.scanline = new byte[this.stride];
        this.lastScanline = new byte[this.stride];
        this.currentScanline = 0;
        this.readFilter = true;
        this.bpp = pNGHeader.bytesPerPixel();
        this.filterType = new byte[1];
        this.inflater = new Inflater();
    }

    private int getBytes(byte[] byArray, int n) throws PNGException {
        try {
            return this.inflater.inflate(byArray, n, byArray.length - n);
        }
        catch (DataFormatException dataFormatException) {
            throw new PNGException("Error inflating data.");
        }
    }

    public void addData(PNGData pNGData) throws PNGException {
        int n = 0;
        if (this.isFinished()) {
            return;
        }
        pNGData.feedToInflater(this.inflater);
        do {
            if (this.readFilter && this.getBytes(this.filterType, 0) < 1) {
                return;
            }
            n = this.getBytes(this.scanline, this.offset);
            if (this.offset + n < this.stride) {
                this.offset += n;
                this.readFilter = false;
                continue;
            }
            this.scanline = PNGFilter.unFilterScanline(this.filterType[0], this.scanline, this.lastScanline, this.bpp);
            System.arraycopy(this.scanline, 0, this.raster, this.currentScanline * this.stride, this.stride);
            this.lastScanline = this.scanline;
            this.scanline = new byte[this.scanline.length];
            ++this.currentScanline;
            this.readFilter = true;
            this.offset = 0;
        } while (n > 0 && this.currentScanline < this.header.getHeight());
    }

    public WritableRaster getRaster(PNGHeader pNGHeader) {
        SampleModel sampleModel = null;
        DataBuffer dataBuffer = null;
        int n = pNGHeader.getWidth();
        int n2 = pNGHeader.getHeight();
        int n3 = pNGHeader.getDepth();
        block0 : switch (pNGHeader.getColorType()) {
            case 4: {
                int n4;
                if (n3 == 8) {
                    n4 = 0;
                    dataBuffer = this.getByteBuffer();
                } else {
                    n4 = 1;
                    dataBuffer = this.getShortBuffer();
                }
                sampleModel = new ComponentSampleModel(n4, n, n2, 2, n * 2, new int[]{0, 1});
                break;
            }
            case 0: {
                switch (n3) {
                    case 16: {
                        sampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[]{0});
                        dataBuffer = this.getShortBuffer();
                        break block0;
                    }
                    case 8: {
                        sampleModel = new ComponentSampleModel(0, n, n2, 1, n, new int[]{0});
                        dataBuffer = this.getByteBuffer();
                        break block0;
                    }
                }
                sampleModel = new MultiPixelPackedSampleModel(0, n, n2, n3);
                dataBuffer = this.getByteBuffer();
                break;
            }
            case 2: {
                int n5;
                if (n3 == 8) {
                    n5 = 0;
                    dataBuffer = this.getByteBuffer();
                } else {
                    n5 = 1;
                    dataBuffer = this.getShortBuffer();
                }
                sampleModel = new ComponentSampleModel(n5, n, n2, 3, 3 * n, new int[]{0, 1, 2});
                break;
            }
            case 6: {
                int n6;
                if (n3 == 8) {
                    n6 = 0;
                    dataBuffer = this.getByteBuffer();
                } else {
                    n6 = 1;
                    dataBuffer = this.getShortBuffer();
                }
                sampleModel = new ComponentSampleModel(n6, n, n2, 4, n * 4, new int[]{0, 1, 2, 3});
                break;
            }
            case 3: {
                sampleModel = n3 == 8 ? new SinglePixelPackedSampleModel(0, n, n2, new int[]{255}) : new MultiPixelPackedSampleModel(0, n, n2, n3);
                dataBuffer = this.getByteBuffer();
            }
        }
        return Raster.createWritableRaster(sampleModel, dataBuffer, null);
    }

    private DataBuffer getShortBuffer() {
        short[] sArray = new short[this.raster.length >> 1];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)((this.raster[i * 2] & 0xFF) << 8 | this.raster[i * 2 + 1] & 0xFF);
        }
        return new DataBufferUShort(sArray, sArray.length);
    }

    private DataBuffer getByteBuffer() {
        return new DataBufferByte(this.raster, this.raster.length);
    }

    public ColorModel getColorModel(ColorSpace colorSpace, int n, int n2) {
        int[] nArray;
        boolean bl = false;
        switch (n) {
            case 4: {
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                bl = true;
                nArray = new int[]{n2, n2};
                break;
            }
            case 2: {
                nArray = new int[]{n2, n2, n2};
                break;
            }
            case 6: {
                bl = true;
                nArray = new int[]{n2, n2, n2, n2};
                break;
            }
            case 0: {
                if (n2 < 8) {
                    return this.grayPalette(n2);
                }
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                nArray = new int[]{n2};
                break;
            }
            default: {
                return null;
            }
        }
        if (colorSpace == null) {
            colorSpace = ColorSpace.getInstance(1000);
        }
        return new ComponentColorModel(colorSpace, nArray, bl, false, bl ? 3 : 1, n2 == 16 ? 1 : 0);
    }

    private IndexColorModel grayPalette(int n) {
        byte[] byArray = new byte[1 << n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(255.0 * ((double)i / ((double)byArray.length - 1.0)));
        }
        return new IndexColorModel(8, byArray.length, byArray, byArray, byArray);
    }

    public byte[] getRaster() {
        return this.raster;
    }

    public boolean isFinished() {
        return this.currentScanline >= this.header.getHeight();
    }
}

