/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGDecoder;
import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class JPEGImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "GNU";
    static final String version = "0.1";
    static final String readerClassName = "gnu.javax.imageio.jpeg.JPEGImageReader";
    static final String[] names = new String[]{"JPEG"};
    static final String[] suffixes = new String[]{".jpeg", ".jpg", ".jpe"};
    static final String[] MIMETypes = new String[]{"image/jpeg"};
    static final String[] writerSpiNames = new String[]{"gnu.javax.imageio.jpeg.JPEGImageWriterSpi"};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = null;
    static final String[] extraStreamMetadataFormatClassNames = null;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = null;
    static final String[] extraImageMetadataFormatClassNames = null;
    private static JPEGImageReaderSpi readerSpi;

    public JPEGImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, STANDARD_INPUT_TYPE, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        System.out.println("JPEGImageReaderSPI!!!");
    }

    public String getDescription(Locale locale) {
        return "JPEG ISO 10918-1, JFIF V1.02";
    }

    public boolean canDecodeInput(Object object) throws IOException {
        boolean bl;
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            new JPEGDecoder(imageInputStream);
            bl = true;
        }
        catch (JPEGException jPEGException) {
            bl = false;
        }
        imageInputStream.reset();
        return bl;
    }

    public ImageReader createReaderInstance(Object object) {
        return new JPEGImageReader(this);
    }

    public static void registerSpis(IIORegistry iIORegistry) {
        iIORegistry.registerServiceProvider(JPEGImageReaderSpi.getReaderSpi(), ImageReaderSpi.class);
    }

    public static synchronized JPEGImageReaderSpi getReaderSpi() {
        if (readerSpi == null) {
            readerSpi = new JPEGImageReaderSpi();
        }
        return readerSpi;
    }
}

