/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGMarkerFoundException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class JPEGImageInputStream
extends ImageInputStreamImpl {
    private ImageInputStream in;
    byte marker;

    public JPEGImageInputStream(ImageInputStream imageInputStream) {
        this.in = imageInputStream;
    }

    public int read() throws IOException {
        this.setBitOffset(0);
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.setBitOffset(0);
        return this.in.read(byArray, n, n2);
    }

    private byte pullByte() throws IOException, JPEGMarkerFoundException {
        byte by;
        byte by2 = this.readByte();
        if (by2 == -1 && (by = this.readByte()) != 0) {
            this.marker = by;
            throw new JPEGMarkerFoundException();
        }
        return by2;
    }

    public byte getMarker() {
        return this.marker;
    }

    public int readBit() throws IOException, JPEGMarkerFoundException {
        this.checkClosed();
        int n = this.bitOffset + 1 & 7;
        byte by = this.pullByte();
        if (this.bitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            by = (byte)(by >> 8 - n);
        }
        this.bitOffset = n;
        return by & 1;
    }

    public byte findNextMarker() throws IOException {
        boolean bl = false;
        byte by = 0;
        this.setBitOffset(0);
        while (true) {
            by = this.readByte();
            if (!bl) {
                if (by != -1) continue;
                bl = true;
                continue;
            }
            if (by == -1) continue;
            if (by != 0) break;
            bl = false;
        }
        return by;
    }
}

