/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import java.io.IOException;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;

public class HuffmanTable {
    public static final int HUFFMAN_MAX_TABLES = 4;
    private short[] huffcode = new short[256];
    private short[] huffsize = new short[256];
    private short[] EHUFCO;
    private short[] EHUFSI;
    private short[] valptr = new short[16];
    private short[] mincode = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private short[] maxcode = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private short[] huffval;
    private short[] bits;
    static byte JPEG_DC_TABLE = 0;
    static byte JPEG_AC_TABLE = 1;
    private short lastk = 0;

    public HuffmanTable(JPEGHuffmanTable jPEGHuffmanTable) {
        this.huffcode = jPEGHuffmanTable.getValues();
        this.bits = jPEGHuffmanTable.getLengths();
    }

    private void generateSizeTable() {
        short s = 0;
        for (int n = 0; n < this.bits.length; n = (int)((short)(n + 1))) {
            for (short s2 = 0; s2 < this.bits[n]; s2 = (short)(s2 + 1)) {
                this.huffsize[s] = (short)(n + 1);
                s = (short)(s + 1);
            }
        }
        this.lastk = s;
    }

    private void generateCodeTable() {
        int n = 0;
        short s = this.huffsize[0];
        int n2 = 0;
        for (int n3 = 0; n3 < this.huffsize.length; n3 = (int)((short)(n3 + 1))) {
            while (this.huffsize[n] == s) {
                this.huffcode[n] = n2;
                n2 = (short)(n2 + 1);
                n = (short)(n + 1);
            }
            n2 = (short)(n2 << 1);
            s = (short)(s + 1);
        }
    }

    private void generateDecoderTables() {
        short s = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.bits[i] != 0) {
                this.valptr[i] = s;
            }
            for (int j = 0; j < this.bits[i]; ++j) {
                if (this.huffcode[j + s] < this.mincode[i] || this.mincode[i] == -1) {
                    this.mincode[i] = this.huffcode[j + s];
                }
                if (this.huffcode[j + s] <= this.maxcode[i]) continue;
                this.maxcode[i] = this.huffcode[j + s];
            }
            if (this.mincode[i] != -1) {
                this.valptr[i] = (short)(this.valptr[i] - this.mincode[i]);
            }
            s = (short)(s + this.bits[i]);
        }
    }

    public void orderCodes(boolean bl) {
        this.EHUFCO = new short[bl ? 15 : 255];
        this.EHUFSI = new short[bl ? 15 : 255];
        for (int i = 0; i < this.lastk; ++i) {
            short s = this.huffval[i];
            if (s < 0 || s > this.EHUFCO.length || this.EHUFSI[s] != 0) {
                System.err.println("Error, bad huffman table.");
            }
            this.EHUFCO[s] = this.huffcode[i];
            this.EHUFSI[s] = this.huffsize[i];
        }
    }

    public static int extend(int n, int n2) {
        int n3 = (int)Math.pow(2.0, n2 - 1);
        if (n < n3) {
            n3 = (-1 << n2) + 1;
            n += n3;
        }
        return n;
    }

    public int decode(JPEGImageInputStream jPEGImageInputStream) throws IOException, JPEGException {
        int n = 0;
        short s = (short)jPEGImageInputStream.readBits(1);
        while (s > this.maxcode[n]) {
            ++n;
            s = (short)(s << 1);
            s = (short)((long)s | jPEGImageInputStream.readBits(1));
        }
        int n2 = this.huffval[s + this.valptr[n]];
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }
}

