/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class BMPImageWriter
extends ImageWriter {
    protected BMPEncoder encoder = null;
    protected BMPFileHeader fileHeader = null;
    protected BMPInfoHeader infoHeader = null;

    protected BMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null || imageTypeSpecifier == null) {
            throw new IllegalArgumentException("IIOMetadata and ImageTypeSpecifier cannot be null.");
        }
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("IIOMetadata cannot be null.");
        }
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException, BMPException {
        this.checkStream();
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.output;
        this.fileHeader = new BMPFileHeader(imageOutputStream, iIOImage);
        this.infoHeader = new BMPInfoHeader(imageOutputStream, iIOImage, imageWriteParam);
        this.encoder = BMPEncoder.getEncoder(this.fileHeader, this.infoHeader);
        if (this.encoder == null) {
            throw new BMPException("Encoder has not been initialized.");
        }
        this.encoder.encode(imageOutputStream, iIOMetadata, iIOImage, imageWriteParam);
    }

    private void checkStream() throws IOException {
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalStateException("Output not an ImageOutputStream.");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output stream.");
        }
    }
}

