/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class BMPFileHeader {
    private static final short bfType = 16973;
    protected long bfSize;
    protected long bfOffBits;
    public static final int SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;

    public BMPFileHeader(ImageInputStream imageInputStream) throws IOException, BMPException {
        byte[] byArray = new byte[14];
        if (imageInputStream.read(byArray) != 14) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBuffer.getShort(0) != 16973) {
            throw new BMPException("Not a BMP file.");
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.bfSize = (long)byteBuffer.getInt(2) & 0xFFFFFFFFFFFFFFFFL;
        this.bfOffBits = (long)byteBuffer.getInt(10) & 0xFFFFFFFFFFFFFFFFL;
    }

    public BMPFileHeader(ImageOutputStream imageOutputStream, IIOImage iIOImage) throws IOException {
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        this.bfOffBits = 54L;
        this.bfSize = (long)(n * n2 * 3 + (4 - n * 3 % 4) * n2) + this.bfOffBits;
        this.write(imageOutputStream);
    }

    public void write(ImageOutputStream imageOutputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(14);
        byteBuffer.putShort(0, (short)16973);
        byteBuffer.putInt(2, (int)(this.bfSize & 0xFFFFFFFFFFFFFFFFL));
        byteBuffer.putInt(6, 0);
        byteBuffer.putInt(7, (int)(this.bfOffBits & 0xFFFFFFFFFFFFFFFFL));
        imageOutputStream.write(byteBuffer.array());
    }

    public void setSize(long l) {
        this.bfSize = l;
    }

    public void setOffset(long l) {
        this.bfOffBits = l;
    }

    public long getSize() {
        return this.bfSize;
    }

    public long getOffset() {
        return this.bfOffBits;
    }
}

