/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.hash.MD5;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Util;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.KeyAgreementFactory;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.sasl.ClientMechanism;
import gnu.javax.crypto.sasl.IllegalMechanismStateException;
import gnu.javax.crypto.sasl.InputBuffer;
import gnu.javax.crypto.sasl.IntegrityException;
import gnu.javax.crypto.sasl.OutputBuffer;
import gnu.javax.crypto.sasl.srp.CALG;
import gnu.javax.crypto.sasl.srp.ClientStore;
import gnu.javax.crypto.sasl.srp.IALG;
import gnu.javax.crypto.sasl.srp.KDF;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPRegistry;
import gnu.javax.crypto.sasl.srp.SecurityContext;
import gnu.javax.security.auth.Password;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SRPClient
extends ClientMechanism
implements SaslClient {
    private static final Logger log = null;
    private String uid;
    private String U;
    BigInteger N;
    BigInteger g;
    BigInteger A;
    BigInteger B;
    private Password password;
    private byte[] s;
    private byte[] cIV;
    private byte[] sIV;
    private byte[] M1;
    private byte[] M2;
    private byte[] cn;
    private byte[] sn;
    private SRP srp;
    private byte[] sid;
    private int ttl;
    private byte[] sCB;
    private String L;
    private String o;
    private String chosenIntegrityAlgorithm;
    private String chosenConfidentialityAlgorithm;
    private int rawSendSize = 0x7FFFFFFB;
    private byte[] K;
    private boolean replayDetection = true;
    private int inCounter = 0;
    private int outCounter = 0;
    private IALG inMac;
    private IALG outMac;
    private CALG inCipher;
    private CALG outCipher;
    private IKeyAgreementParty clientHandler = KeyAgreementFactory.getPartyAInstance("srp-sasl");
    private PRNG prng = null;

    public SRPClient() {
        super("SRP");
    }

    protected void initMechanism() throws SaslException {
        MD5 mD5 = new MD5();
        byte[] byArray = this.authorizationID.getBytes();
        mD5.update(byArray, 0, byArray.length);
        byArray = this.serverName.getBytes();
        mD5.update(byArray, 0, byArray.length);
        byArray = this.protocol.getBytes();
        mD5.update(byArray, 0, byArray.length);
        if (this.channelBinding.length > 0) {
            mD5.update(this.channelBinding, 0, this.channelBinding.length);
        }
        this.uid = Util.toBase64(mD5.digest());
        if (ClientStore.instance().isAlive(this.uid)) {
            SecurityContext securityContext = ClientStore.instance().restoreSession(this.uid);
            this.srp = SRP.instance(securityContext.getMdName());
            this.sid = securityContext.getSID();
            this.K = securityContext.getK();
            this.cIV = securityContext.getClientIV();
            this.sIV = securityContext.getServerIV();
            this.replayDetection = securityContext.hasReplayDetection();
            this.inCounter = securityContext.getInCounter();
            this.outCounter = securityContext.getOutCounter();
            this.inMac = securityContext.getInMac();
            this.outMac = securityContext.getOutMac();
            this.inCipher = securityContext.getInCipher();
            this.outCipher = securityContext.getOutCipher();
        } else {
            this.sid = new byte[0];
            this.ttl = 0;
            this.K = null;
            this.cIV = null;
            this.sIV = null;
            this.cn = null;
            this.sn = null;
        }
    }

    protected void resetMechanism() throws SaslException {
        try {
            this.password.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            SaslException saslException = new SaslException("resetMechanism()");
            saslException.initCause(destroyFailedException);
            throw saslException;
        }
        this.password = null;
        this.M1 = null;
        this.K = null;
        this.cIV = null;
        this.sIV = null;
        this.outMac = null;
        this.inMac = null;
        this.outCipher = null;
        this.inCipher = null;
        this.sid = null;
        this.ttl = 0;
        this.cn = null;
        this.sn = null;
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        switch (this.state) {
            case 0: {
                ++this.state;
                return this.sendIdentities();
            }
            case 1: {
                ++this.state;
                byte[] byArray2 = this.sendPublicKey(byArray);
                try {
                    this.password.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {
                    SaslException saslException = new SaslException("sendPublicKey()");
                    saslException.initCause(saslException);
                    throw saslException;
                }
                return byArray2;
            }
            case 2: {
                if (this.complete) break;
                ++this.state;
                return this.receiveEvidence(byArray);
            }
        }
        throw new IllegalMechanismStateException("evaluateChallenge()");
    }

    protected byte[] engineUnwrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2;
        if (this.inMac == null && this.inCipher == null) {
            throw new IllegalStateException("connection is not protected");
        }
        try {
            if (this.inMac != null) {
                byte[] byArray3;
                int n3 = this.inMac.length();
                int n4 = n2 - n3;
                byte[] byArray4 = new byte[n3];
                System.arraycopy(byArray, n + n4, byArray4, 0, n3);
                this.inMac.update(byArray, n, n4);
                if (this.replayDetection) {
                    ++this.inCounter;
                    this.inMac.update(new byte[]{(byte)(this.inCounter >>> 24), (byte)(this.inCounter >>> 16), (byte)(this.inCounter >>> 8), (byte)this.inCounter});
                }
                if (!Arrays.equals(byArray4, byArray3 = this.inMac.doFinal())) {
                    throw new IntegrityException("engineUnwrap()");
                }
                if (this.inCipher != null) {
                    byArray2 = this.inCipher.doFinal(byArray, n, n4);
                } else {
                    byArray2 = new byte[n2 - n3];
                    System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                }
            } else {
                byArray2 = this.inCipher.doFinal(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new SaslException("engineUnwrap()", iOException);
        }
        return byArray2;
    }

    protected byte[] engineWrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2;
        if (this.outMac == null && this.outCipher == null) {
            throw new IllegalStateException("connection is not protected");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this.outCipher != null) {
                byArray2 = this.outCipher.doFinal(byArray, n, n2);
                byteArrayOutputStream.write(byArray2);
                if (this.outMac != null) {
                    this.outMac.update(byArray2);
                    if (this.replayDetection) {
                        ++this.outCounter;
                        this.outMac.update(new byte[]{(byte)(this.outCounter >>> 24), (byte)(this.outCounter >>> 16), (byte)(this.outCounter >>> 8), (byte)this.outCounter});
                    }
                    byte[] byArray3 = this.outMac.doFinal();
                    byteArrayOutputStream.write(byArray3);
                }
            } else {
                byteArrayOutputStream.write(byArray, n, n2);
                this.outMac.update(byArray, n, n2);
                if (this.replayDetection) {
                    ++this.outCounter;
                    this.outMac.update(new byte[]{(byte)(this.outCounter >>> 24), (byte)(this.outCounter >>> 16), (byte)(this.outCounter >>> 8), (byte)this.outCounter});
                }
                byte[] byArray4 = this.outMac.doFinal();
                byteArrayOutputStream.write(byArray4);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new SaslException("engineWrap()", iOException);
        }
        return byArray2;
    }

    protected String getNegotiatedQOP() {
        if (this.inMac != null) {
            if (this.inCipher != null) {
                return "auth-conf";
            }
            return "auth-int";
        }
        return "auth";
    }

    protected String getNegotiatedStrength() {
        if (this.inMac != null) {
            if (this.inCipher != null) {
                return "high";
            }
            return "medium";
        }
        return "low";
    }

    protected String getNegotiatedRawSendSize() {
        return String.valueOf(this.rawSendSize);
    }

    protected String getReuse() {
        return "true";
    }

    private byte[] sendIdentities() throws SaslException {
        this.getUsernameAndPassword();
        if (this.sid.length != 0) {
            this.cn = new byte[16];
            this.getDefaultPRNG().nextBytes(this.cn);
        } else {
            this.cn = new byte[0];
        }
        OutputBuffer outputBuffer = new OutputBuffer();
        try {
            outputBuffer.setText(this.U);
            outputBuffer.setText(this.authorizationID);
            outputBuffer.setEOS(this.sid);
            outputBuffer.setOS(this.cn);
            outputBuffer.setEOS(this.channelBinding);
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("sendIdentities()", iOException);
        }
        byte[] byArray = outputBuffer.encode();
        return byArray;
    }

    private byte[] sendPublicKey(byte[] byArray) throws SaslException {
        int n;
        block15: {
            InputBuffer inputBuffer = new InputBuffer(byArray);
            try {
                n = (int)inputBuffer.getScalar(1);
                if (n == 0) {
                    this.N = inputBuffer.getMPI();
                    this.g = inputBuffer.getMPI();
                    this.s = inputBuffer.getOS();
                    this.B = inputBuffer.getMPI();
                    this.L = inputBuffer.getText();
                    break block15;
                }
                if (n == 255) {
                    this.sn = inputBuffer.getOS();
                    this.sCB = inputBuffer.getEOS();
                    break block15;
                }
                throw new SaslException("sendPublicKey(): Invalid scalar (" + n + ") in server's request");
            }
            catch (IOException iOException) {
                if (iOException instanceof SaslException) {
                    throw (SaslException)iOException;
                }
                throw new SaslException("sendPublicKey()", iOException);
            }
        }
        if (n == 0) {
            Object object;
            Object object2;
            this.o = this.createO(this.L.toLowerCase());
            byte[] byArray2 = this.password.getBytes();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("gnu.crypto.srp6.ka.H", this.srp.getAlgorithm());
            hashMap.put("gnu.crypto.srp6.ka.I", this.U);
            hashMap.put("gnu.crypto.srp6.ka.p", byArray2);
            try {
                this.clientHandler.init(hashMap);
                this.clientHandler.processMessage(null);
            }
            catch (KeyAgreementException keyAgreementException) {
                throw new SaslException("sendPublicKey()", keyAgreementException);
            }
            try {
                object2 = new OutgoingMessage();
                ((OutgoingMessage)object2).writeMPI(this.N);
                ((OutgoingMessage)object2).writeMPI(this.g);
                ((OutgoingMessage)object2).writeMPI(new BigInteger(1, this.s));
                ((OutgoingMessage)object2).writeMPI(this.B);
                object = new IncomingMessage(((OutgoingMessage)object2).toByteArray());
                object2 = this.clientHandler.processMessage((IncomingMessage)object);
                object = new IncomingMessage(((OutgoingMessage)object2).toByteArray());
                this.A = ((IncomingMessage)object).readMPI();
                this.K = this.clientHandler.getSharedSecret();
            }
            catch (KeyAgreementException keyAgreementException) {
                throw new SaslException("sendPublicKey()", keyAgreementException);
            }
            try {
                this.M1 = this.srp.generateM1(this.N, this.g, this.U, this.s, this.A, this.B, this.K, this.authorizationID, this.L, this.cn, this.channelBinding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AuthenticationException("sendPublicKey()", unsupportedEncodingException);
            }
            object2 = new OutputBuffer();
            try {
                ((OutputBuffer)object2).setMPI(this.A);
                ((OutputBuffer)object2).setOS(this.M1);
                ((OutputBuffer)object2).setText(this.o);
                ((OutputBuffer)object2).setOS(this.cIV);
            }
            catch (IOException iOException) {
                if (iOException instanceof SaslException) {
                    throw (SaslException)iOException;
                }
                throw new AuthenticationException("sendPublicKey()", iOException);
            }
            object = ((OutputBuffer)object2).encode();
            return object;
        }
        this.setupSecurityServices(true);
        return null;
    }

    private byte[] receiveEvidence(byte[] byArray) throws SaslException {
        byte[] byArray2;
        InputBuffer inputBuffer = new InputBuffer(byArray);
        try {
            this.M2 = inputBuffer.getOS();
            this.sIV = inputBuffer.getOS();
            this.sid = inputBuffer.getEOS();
            this.ttl = (int)inputBuffer.getScalar(4);
            this.sCB = inputBuffer.getEOS();
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("receiveEvidence()", iOException);
        }
        try {
            byArray2 = this.srp.generateM2(this.A, this.M1, this.K, this.U, this.authorizationID, this.o, this.sid, this.ttl, this.cIV, this.sIV, this.sCB);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("receiveEvidence()", unsupportedEncodingException);
        }
        if (!Arrays.equals(this.M2, byArray2)) {
            throw new AuthenticationException("M2 mismatch");
        }
        this.setupSecurityServices(false);
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getUsernameAndPassword() throws AuthenticationException {
        try {
            if (!this.properties.containsKey("gnu.crypto.sasl.username") && !this.properties.containsKey("gnu.crypto.sasl.password")) {
                void var1_5;
                String string = System.getProperty("user.name");
                if (string == null) {
                    NameCallback nameCallback = new NameCallback("username: ");
                } else {
                    NameCallback nameCallback = new NameCallback("username: ", string);
                }
                PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
                this.handler.handle(new Callback[]{var1_5, passwordCallback});
                this.U = var1_5.getName();
                this.password = new Password(passwordCallback.getPassword());
            } else {
                if (this.properties.containsKey("gnu.crypto.sasl.username")) {
                    this.U = (String)this.properties.get("gnu.crypto.sasl.username");
                } else {
                    void var1_8;
                    String string = System.getProperty("user.name");
                    if (string == null) {
                        NameCallback nameCallback = new NameCallback("username: ");
                    } else {
                        NameCallback nameCallback = new NameCallback("username: ", string);
                    }
                    this.handler.handle(new Callback[]{var1_8});
                    this.U = var1_8.getName();
                }
                if (this.properties.containsKey("gnu.crypto.sasl.password")) {
                    Object v = this.properties.get("gnu.crypto.sasl.password");
                    if (v instanceof char[]) {
                        this.password = new Password((char[])v);
                    } else if (v instanceof Password) {
                        this.password = (Password)v;
                    } else {
                        if (!(v instanceof String)) throw new IllegalArgumentException(v.getClass().getName() + "is not a valid password class");
                        this.password = new Password(((String)v).toCharArray());
                    }
                } else {
                    PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
                    this.handler.handle(new Callback[]{passwordCallback});
                    this.password = new Password(passwordCallback.getPassword());
                }
            }
            if (this.U == null) {
                throw new AuthenticationException("null username supplied");
            }
            if (this.password != null) return;
            throw new AuthenticationException("null password supplied");
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new AuthenticationException("getUsernameAndPassword()", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new AuthenticationException("getUsernameAndPassword()", iOException);
        }
    }

    private String createO(String string) throws AuthenticationException {
        Object object;
        boolean bl;
        String string2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string3 = "replay_detection";
        String string4 = SRPRegistry.SRP_DEFAULT_DIGEST_NAME;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        block2: while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string5 = stringTokenizer.nextToken();
            if (string5.startsWith("mda=")) {
                string5 = string5.substring(string5.indexOf(61) + 1);
                for (n = 0; n < SRPRegistry.INTEGRITY_ALGORITHMS.length; ++n) {
                    if (!SRPRegistry.SRP_ALGORITHMS[n].equals(string5)) continue;
                    string4 = string5;
                    continue block2;
                }
                continue;
            }
            if (string5.equals("replay_detection")) {
                bl2 = true;
                continue;
            }
            if (string5.startsWith("integrity=")) {
                string5 = string5.substring(string5.indexOf(61) + 1);
                for (n = 0; n < SRPRegistry.INTEGRITY_ALGORITHMS.length; ++n) {
                    if (!SRPRegistry.INTEGRITY_ALGORITHMS[n].equals(string5)) continue;
                    this.chosenIntegrityAlgorithm = string5;
                    bl3 = true;
                    continue block2;
                }
                continue;
            }
            if (string5.startsWith("confidentiality=")) {
                string5 = string5.substring(string5.indexOf(61) + 1);
                for (n = 0; n < SRPRegistry.CONFIDENTIALITY_ALGORITHMS.length; ++n) {
                    if (!SRPRegistry.CONFIDENTIALITY_ALGORITHMS[n].equals(string5)) continue;
                    this.chosenConfidentialityAlgorithm = string5;
                    bl4 = true;
                    continue block2;
                }
                continue;
            }
            if (string5.startsWith("mandatory=")) {
                string3 = string5.substring(string5.indexOf(61) + 1);
                continue;
            }
            if (!string5.startsWith("maxbuffersize=")) continue;
            string2 = string5.substring(string5.indexOf(61) + 1);
            try {
                this.rawSendSize = Integer.parseInt(string2);
                if (this.rawSendSize <= 0x7FFFFFFB && this.rawSendSize >= 1) continue;
                throw new AuthenticationException("Illegal value for 'maxbuffersize' option");
            }
            catch (NumberFormatException numberFormatException) {
                throw new AuthenticationException("maxbuffersize=" + string2, numberFormatException);
            }
        }
        string2 = (String)this.properties.get("gnu.crypto.sasl.srp.replay.detection");
        Boolean bl5 = Boolean.valueOf(string2);
        this.replayDetection = bl2 && bl5 != false;
        string2 = (String)this.properties.get("gnu.crypto.sasl.srp.integrity");
        bl5 = Boolean.valueOf(string2);
        boolean bl6 = bl3 && bl5 != false;
        string2 = (String)this.properties.get("gnu.crypto.sasl.srp.confidentiality");
        bl5 = Boolean.valueOf(string2);
        boolean bl7 = bl = bl4 && bl5 != false;
        if ("replay_detection".equals(string3)) {
            this.replayDetection = true;
            bl6 = true;
        } else if ("integrity".equals(string3)) {
            bl6 = true;
        } else if ("confidentiality".equals(string3)) {
            bl = true;
        }
        if (this.replayDetection && this.chosenIntegrityAlgorithm == null) {
            throw new AuthenticationException("Replay detection is required but no integrity protection algorithm was chosen");
        }
        if (bl6 && this.chosenIntegrityAlgorithm == null) {
            throw new AuthenticationException("Integrity protection is required but no algorithm was chosen");
        }
        if (bl && this.chosenConfidentialityAlgorithm == null) {
            throw new AuthenticationException("Confidentiality protection is required but no algorithm was chosen");
        }
        if (this.chosenConfidentialityAlgorithm == null) {
            this.cIV = new byte[0];
        } else {
            object = CipherFactory.getInstance(this.chosenConfidentialityAlgorithm);
            if (object == null) {
                throw new AuthenticationException("createO()", new NoSuchAlgorithmException());
            }
            int n = object.defaultBlockSize();
            this.cIV = new byte[n];
            this.getDefaultPRNG().nextBytes(this.cIV);
        }
        this.srp = SRP.instance(string4);
        object = new CPStringBuilder();
        ((CPStringBuilder)object).append("mda").append("=").append(string4).append(",");
        if (this.replayDetection) {
            ((CPStringBuilder)object).append("replay_detection").append(",");
        }
        if (bl6) {
            ((CPStringBuilder)object).append("integrity").append("=").append(this.chosenIntegrityAlgorithm).append(",");
        }
        if (bl) {
            ((CPStringBuilder)object).append("confidentiality").append("=").append(this.chosenConfidentialityAlgorithm).append(",");
        }
        String string6 = ((CPStringBuilder)object).append("maxbuffersize").append("=").append(0x7FFFFFFB).toString();
        return string6;
    }

    private void setupSecurityServices(boolean bl) throws SaslException {
        this.complete = true;
        if (!bl) {
            this.inCounter = 0;
            this.outCounter = 0;
            if (this.chosenConfidentialityAlgorithm != null) {
                this.inCipher = CALG.getInstance(this.chosenConfidentialityAlgorithm);
                this.outCipher = CALG.getInstance(this.chosenConfidentialityAlgorithm);
            }
            if (this.chosenIntegrityAlgorithm != null) {
                this.inMac = IALG.getInstance(this.chosenIntegrityAlgorithm);
                this.outMac = IALG.getInstance(this.chosenIntegrityAlgorithm);
            }
        } else {
            this.K = this.srp.generateKn(this.K, this.cn, this.sn);
        }
        KDF kDF = KDF.getInstance(this.K);
        if (this.inCipher != null) {
            this.inCipher.init(kDF, this.sIV, Direction.REVERSED);
            this.outCipher.init(kDF, this.cIV, Direction.FORWARD);
        }
        if (this.inMac != null) {
            this.inMac.init(kDF);
            this.outMac.init(kDF);
        }
        if (this.sid != null && this.sid.length != 0) {
            ClientStore.instance().cacheSession(this.uid, this.ttl, new SecurityContext(this.srp.getAlgorithm(), this.sid, this.K, this.cIV, this.sIV, this.replayDetection, this.inCounter, this.outCounter, this.inMac, this.outMac, this.inCipher, this.outCipher));
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

