/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.util.Util;
import gnu.javax.crypto.sasl.IAuthInfoProvider;
import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.srp.PasswordFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.AuthenticationException;

public class SRPAuthInfoProvider
implements IAuthInfoProvider {
    private PasswordFile passwordFile = null;

    public void activate(Map map) throws AuthenticationException {
        try {
            if (map == null) {
                this.passwordFile = new PasswordFile();
            } else {
                this.passwordFile = (PasswordFile)map.get("gnu.crypto.sasl.srp.password.db");
                if (this.passwordFile == null) {
                    String string = (String)map.get("gnu.crypto.sasl.srp.password.file");
                    this.passwordFile = string == null ? new PasswordFile() : new PasswordFile(string);
                }
            }
        }
        catch (IOException iOException) {
            throw new AuthenticationException("activate()", iOException);
        }
    }

    public void passivate() throws AuthenticationException {
        this.passwordFile = null;
    }

    public boolean contains(String string) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("contains()", new IllegalStateException());
        }
        boolean bl = false;
        try {
            bl = this.passwordFile.contains(string);
        }
        catch (IOException iOException) {
            throw new AuthenticationException("contains()", iOException);
        }
        return bl;
    }

    public Map lookup(Map map) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("lookup()", new IllegalStateException());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string = (String)map.get("gnu.crypto.sasl.username");
            if (string == null) {
                throw new NoSuchUserException("");
            }
            String string2 = (String)map.get("srp.md.name");
            String[] stringArray = this.passwordFile.lookup(string, string2);
            hashMap.put("srp.user.verifier", stringArray[0]);
            hashMap.put("srp.salt", stringArray[1]);
            hashMap.put("srp.config.ndx", stringArray[2]);
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                throw (AuthenticationException)exception;
            }
            throw new AuthenticationException("lookup()", exception);
        }
        return hashMap;
    }

    public void update(Map map) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("update()", new IllegalStateException());
        }
        try {
            String string = (String)map.get("gnu.crypto.sasl.username");
            String string2 = (String)map.get("gnu.crypto.sasl.password");
            String string3 = (String)map.get("srp.salt");
            String string4 = (String)map.get("srp.config.ndx");
            if (string3 == null || string4 == null) {
                this.passwordFile.changePasswd(string, string2);
            } else {
                this.passwordFile.add(string, string2, Util.fromBase64(string3), string4);
            }
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                throw (AuthenticationException)exception;
            }
            throw new AuthenticationException("update()", exception);
        }
    }

    public Map getConfiguration(String string) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("getConfiguration()", new IllegalStateException());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = this.passwordFile.lookupConfig(string);
            hashMap.put("srp.N", stringArray[0]);
            hashMap.put("srp.g", stringArray[1]);
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                throw (AuthenticationException)exception;
            }
            throw new AuthenticationException("getConfiguration()", exception);
        }
        return hashMap;
    }
}

