/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.util.Util;
import gnu.javax.crypto.sasl.srp.SRPRegistry;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;

public final class SRP {
    private static final HashMap algorithms = new HashMap();
    private static final byte COLON = 58;
    private IMessageDigest mda;

    private SRP(IMessageDigest iMessageDigest) {
        this.mda = iMessageDigest;
    }

    public static synchronized SRP instance(String string) {
        SRP sRP;
        if (string != null) {
            string = string.trim().toLowerCase();
        }
        if (string == null || string.equals("")) {
            string = SRPRegistry.SRP_DEFAULT_DIGEST_NAME;
        }
        if ((sRP = (SRP)algorithms.get(string)) == null) {
            IMessageDigest iMessageDigest = HashFactory.getInstance(string);
            sRP = new SRP(iMessageDigest);
            algorithms.put(string, sRP);
        }
        return sRP;
    }

    private static final byte[] xor(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public String getAlgorithm() {
        return this.mda.name();
    }

    public IMessageDigest newDigest() {
        return (IMessageDigest)this.mda.clone();
    }

    public byte[] digest(byte[] byArray) {
        IMessageDigest iMessageDigest = (IMessageDigest)this.mda.clone();
        iMessageDigest.update(byArray, 0, byArray.length);
        return iMessageDigest.digest();
    }

    public byte[] digest(String string) throws UnsupportedEncodingException {
        return this.digest(string.getBytes("US-ASCII"));
    }

    public byte[] xor(byte[] byArray, byte[] byArray2) {
        return SRP.xor(byArray, byArray2, this.mda.hashSize());
    }

    public byte[] generateM1(BigInteger bigInteger, BigInteger bigInteger2, String string, byte[] byArray, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray2, String string2, String string3, byte[] byArray3, byte[] byArray4) throws UnsupportedEncodingException {
        IMessageDigest iMessageDigest = (IMessageDigest)this.mda.clone();
        byte[] byArray5 = this.xor(this.digest(Util.trim(bigInteger)), this.digest(Util.trim(bigInteger2)));
        iMessageDigest.update(byArray5, 0, byArray5.length);
        byArray5 = this.digest(string);
        iMessageDigest.update(byArray5, 0, byArray5.length);
        iMessageDigest.update(byArray, 0, byArray.length);
        byArray5 = Util.trim(bigInteger3);
        iMessageDigest.update(byArray5, 0, byArray5.length);
        byArray5 = Util.trim(bigInteger4);
        iMessageDigest.update(byArray5, 0, byArray5.length);
        iMessageDigest.update(byArray2, 0, byArray2.length);
        byArray5 = this.digest(string2);
        iMessageDigest.update(byArray5, 0, byArray5.length);
        byArray5 = this.digest(string3);
        iMessageDigest.update(byArray5, 0, byArray5.length);
        iMessageDigest.update(byArray3, 0, byArray3.length);
        iMessageDigest.update(byArray4, 0, byArray4.length);
        return iMessageDigest.digest();
    }

    public byte[] generateM2(BigInteger bigInteger, byte[] byArray, byte[] byArray2, String string, String string2, String string3, byte[] byArray3, int n, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws UnsupportedEncodingException {
        IMessageDigest iMessageDigest = (IMessageDigest)this.mda.clone();
        byte[] byArray7 = Util.trim(bigInteger);
        iMessageDigest.update(byArray7, 0, byArray7.length);
        iMessageDigest.update(byArray, 0, byArray.length);
        iMessageDigest.update(byArray2, 0, byArray2.length);
        byArray7 = this.digest(string);
        iMessageDigest.update(byArray7, 0, byArray7.length);
        byArray7 = this.digest(string2);
        iMessageDigest.update(byArray7, 0, byArray7.length);
        byArray7 = this.digest(string3);
        iMessageDigest.update(byArray7, 0, byArray7.length);
        iMessageDigest.update(byArray3, 0, byArray3.length);
        iMessageDigest.update((byte)(n >>> 24));
        iMessageDigest.update((byte)(n >>> 16));
        iMessageDigest.update((byte)(n >>> 8));
        iMessageDigest.update((byte)n);
        iMessageDigest.update(byArray4, 0, byArray4.length);
        iMessageDigest.update(byArray5, 0, byArray5.length);
        iMessageDigest.update(byArray6, 0, byArray6.length);
        return iMessageDigest.digest();
    }

    public byte[] generateKn(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        IMessageDigest iMessageDigest = (IMessageDigest)this.mda.clone();
        iMessageDigest.update(byArray, 0, byArray.length);
        iMessageDigest.update(byArray2, 0, byArray2.length);
        iMessageDigest.update(byArray3, 0, byArray3.length);
        return iMessageDigest.digest();
    }

    public byte[] computeX(byte[] byArray, String string, String string2) throws UnsupportedEncodingException {
        return this.computeX(byArray, string.getBytes("US-ASCII"), string2.getBytes("US-ASCII"));
    }

    public byte[] computeX(byte[] byArray, String string, byte[] byArray2) throws UnsupportedEncodingException {
        return this.computeX(byArray, string.getBytes("US-ASCII"), byArray2);
    }

    private byte[] computeX(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        IMessageDigest iMessageDigest = (IMessageDigest)this.mda.clone();
        iMessageDigest.update(byArray2, 0, byArray2.length);
        iMessageDigest.update((byte)58);
        iMessageDigest.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = iMessageDigest.digest();
        iMessageDigest.update(byArray, 0, byArray.length);
        iMessageDigest.update(byArray4, 0, byArray4.length);
        return iMessageDigest.digest();
    }
}

