/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.prng.UMacGenerator;
import java.util.HashMap;

public class KDF {
    private static final int AES_BLOCK_SIZE = 16;
    private static final int AES_KEY_SIZE = 16;
    private static final byte[] buffer = new byte[1];
    private static final PRNG prng = PRNG.getInstance();
    private UMacGenerator umac = null;

    private KDF(byte[] byArray, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.prng.umac.cipher.name", "aes");
        hashMap.put("gnu.crypto.prng.umac.index", n);
        hashMap.put("gnu.crypto.cipher.block.size", 16);
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        hashMap.put("gnu.crypto.cipher.key.material", byArray2);
        this.umac = new UMacGenerator();
        this.umac.init(hashMap);
    }

    static final KDF getInstance(byte[] byArray) {
        byte[] byArray2;
        int n = -1;
        if (byArray != null) {
            byArray2 = byArray;
            n = 0;
        } else {
            byArray2 = new byte[16];
            while (n < 1 || n > 255) {
                n = (byte)KDF.nextByte();
            }
        }
        return new KDF(byArray2, n);
    }

    private static final synchronized int nextByte() {
        prng.nextBytes(buffer);
        return buffer[0] & 0xFF;
    }

    public synchronized byte[] derive(int n) {
        byte[] byArray = new byte[n];
        try {
            this.umac.nextBytes(byArray, 0, n);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace(System.err);
        }
        catch (LimitReachedException limitReachedException) {
            limitReachedException.printStackTrace(System.err);
        }
        return byArray;
    }
}

