/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.RandomEvent;
import gnu.java.security.prng.RandomEventListener;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class Fortuna
extends BasePRNG
implements Serializable,
RandomEventListener {
    private static final long serialVersionUID = 16435934L;
    private static final int SEED_FILE_SIZE = 64;
    private static final int NUM_POOLS = 32;
    private static final int MIN_POOL_SIZE = 64;
    private final Generator generator = new Generator(CipherFactory.getInstance("rijndael"), HashFactory.getInstance("sha-256"));
    private final IMessageDigest[] pools = new IMessageDigest[32];
    private long lastReseed;
    private int pool;
    private int pool0Count;
    private int reseedCount;
    public static final String SEED = "gnu.crypto.prng.fortuna.seed";

    public Fortuna() {
        super("fortuna");
        for (int i = 0; i < 32; ++i) {
            this.pools[i] = HashFactory.getInstance("sha-256");
        }
        this.lastReseed = 0L;
        this.pool = 0;
        this.pool0Count = 0;
        this.buffer = new byte[256];
    }

    public void setup(Map map) {
        this.lastReseed = 0L;
        this.reseedCount = 0;
        this.pool = 0;
        this.pool0Count = 0;
        this.generator.init(map);
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException(limitReachedException);
        }
    }

    public void fillBlock() throws LimitReachedException {
        if (this.pool0Count >= 64 && System.currentTimeMillis() - this.lastReseed > 100L) {
            ++this.reseedCount;
            byte[] byArray = new byte[]{};
            for (int i = 0; i < 32; ++i) {
                if (this.reseedCount % (1 << i) != 0) continue;
                this.generator.addRandomBytes(this.pools[i].digest());
            }
            this.lastReseed = System.currentTimeMillis();
            this.pool0Count = 0;
        }
        this.generator.nextBytes(this.buffer);
    }

    public void addRandomByte(byte by) {
        this.pools[this.pool].update(by);
        if (this.pool == 0) {
            ++this.pool0Count;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addRandomBytes(byte[] byArray, int n, int n2) {
        this.pools[this.pool].update(byArray, n, n2);
        if (this.pool == 0) {
            this.pool0Count += n2;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addRandomEvent(RandomEvent randomEvent) {
        if (randomEvent.getPoolNumber() < 0 || randomEvent.getPoolNumber() >= this.pools.length) {
            throw new IllegalArgumentException("pool number out of range: " + randomEvent.getPoolNumber());
        }
        this.pools[randomEvent.getPoolNumber()].update(randomEvent.getSourceNumber());
        this.pools[randomEvent.getPoolNumber()].update((byte)randomEvent.getData().length);
        this.pools[randomEvent.getPoolNumber()].update(randomEvent.getData());
        if (randomEvent.getPoolNumber() == 0) {
            this.pool0Count += randomEvent.getData().length;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[64];
        try {
            this.generator.nextBytes(byArray);
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException);
        }
        objectOutputStream.write(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        byte[] byArray = new byte[64];
        objectInputStream.readFully(byArray);
        this.generator.addRandomBytes(byArray);
    }

    public static class Generator
    extends BasePRNG
    implements Cloneable {
        private static final int LIMIT = 0x100000;
        private final IBlockCipher cipher;
        private final IMessageDigest hash;
        private final byte[] counter;
        private final byte[] key;
        private boolean seeded;

        public Generator(IBlockCipher iBlockCipher, IMessageDigest iMessageDigest) {
            super("fortuna-generator");
            this.cipher = iBlockCipher;
            this.hash = iMessageDigest;
            this.counter = new byte[iBlockCipher.defaultBlockSize()];
            this.buffer = new byte[iBlockCipher.defaultBlockSize()];
            int n = 0;
            Iterator iterator = iBlockCipher.keySizes();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 > n) {
                    n = n2;
                }
                if (n < 32) continue;
                break;
            }
            this.key = new byte[n];
        }

        public byte nextByte() {
            byte[] byArray = new byte[1];
            this.nextBytes(byArray, 0, 1);
            return byArray[0];
        }

        public void nextBytes(byte[] byArray, int n, int n2) {
            if (!this.seeded) {
                throw new IllegalStateException("generator not seeded");
            }
            int n3 = 0;
            do {
                int n4 = Math.min(0x100000, n2 - n3);
                try {
                    super.nextBytes(byArray, n + n3, n4);
                }
                catch (LimitReachedException limitReachedException) {
                    throw new Error(limitReachedException);
                }
                n3 += n4;
                for (int i = 0; i < this.key.length; i += this.counter.length) {
                    this.fillBlock();
                    int n5 = Math.min(this.key.length - i, this.cipher.currentBlockSize());
                    System.arraycopy(this.buffer, 0, this.key, i, n5);
                }
                this.resetKey();
            } while (n3 < n2);
            this.fillBlock();
            this.ndx = 0;
        }

        public void addRandomByte(byte by) {
            this.addRandomBytes(new byte[]{by});
        }

        public void addRandomBytes(byte[] byArray, int n, int n2) {
            this.hash.update(this.key);
            this.hash.update(byArray, n, n2);
            byte[] byArray2 = this.hash.digest();
            System.arraycopy(byArray2, 0, this.key, 0, Math.min(this.key.length, byArray2.length));
            this.resetKey();
            this.incrementCounter();
            this.seeded = true;
        }

        public void fillBlock() {
            if (!this.seeded) {
                throw new IllegalStateException("generator not seeded");
            }
            this.cipher.encryptBlock(this.counter, 0, this.buffer, 0);
            this.incrementCounter();
        }

        public void setup(Map map) {
            this.seeded = false;
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.counter, (byte)0);
            byte[] byArray = (byte[])map.get(Fortuna.SEED);
            if (byArray != null) {
                this.addRandomBytes(byArray);
            }
            this.fillBlock();
        }

        private void resetKey() {
            try {
                this.cipher.reset();
                this.cipher.init(Collections.singletonMap("gnu.crypto.cipher.key.material", this.key));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new Error(invalidKeyException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error(illegalArgumentException);
            }
        }

        private void incrementCounter() {
            for (int i = 0; i < this.counter.length; ++i) {
                int n = i;
                this.counter[n] = (byte)(this.counter[n] + 1);
                if (this.counter[i] != 0) break;
            }
        }
    }
}

