/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;

public class TLS1
extends BasePad {
    public TLS1() {
        super("tls1");
    }

    public void setup() {
        if (this.blockSize <= 0 || this.blockSize > 255) {
            throw new IllegalArgumentException("invalid block size: " + this.blockSize);
        }
    }

    public byte[] pad(byte[] byArray, int n, int n2) {
        int n3 = this.blockSize - n2 % this.blockSize;
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = (byte)(n3 - 1);
        }
        return byArray2;
    }

    public int unpad(byte[] byArray, int n, int n2) throws WrongPaddingException {
        int n3 = byArray[n + n2 - 1] & 0xFF;
        for (int i = n + (n2 - n3 - 1); i < n + n2 - 1; ++i) {
            if ((byArray[i] & 0xFF) == n3) continue;
            throw new WrongPaddingException();
        }
        return n3 + 1;
    }
}

