/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;

public class SSL3
extends BasePad {
    public SSL3() {
        super("ssl3");
    }

    public void setup() {
        if (this.blockSize <= 0 || this.blockSize > 255) {
            throw new IllegalArgumentException("invalid block size: " + this.blockSize);
        }
    }

    public byte[] pad(byte[] byArray, int n, int n2) {
        int n3 = this.blockSize - n2 % this.blockSize;
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = (byte)(n3 - 1);
        }
        return byArray2;
    }

    public int unpad(byte[] byArray, int n, int n2) throws WrongPaddingException {
        int n3 = byArray[n + n2 - 1] & 0xFF;
        if (n3 >= this.blockSize) {
            throw new WrongPaddingException();
        }
        return n3 + 1;
    }
}

