/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.Map;
import java.util.logging.Logger;

public abstract class BasePad
implements IPad {
    private static final Logger log = null;
    protected String name;
    protected int blockSize;

    protected BasePad(String string) {
        this.name = string;
        this.blockSize = -1;
    }

    public String name() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.name);
        if (this.blockSize != -1) {
            cPStringBuilder.append('-').append(String.valueOf(8 * this.blockSize));
        }
        return cPStringBuilder.toString();
    }

    public void init(int n) throws IllegalStateException {
        if (this.blockSize != -1) {
            throw new IllegalStateException();
        }
        this.blockSize = n;
        this.setup();
    }

    public void init(Map map) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.blockSize = -1;
    }

    public boolean selfTest() {
        byte[] byArray = new byte[1024];
        for (int i = 2; i < 256; ++i) {
            if (this.test1BlockSize(i, byArray)) continue;
            return false;
        }
        return true;
    }

    protected boolean test1BlockSize(int n, byte[] byArray) {
        int n2 = byArray.length;
        this.init(n);
        for (int i = 0; i < n2 - 5 - this.blockSize; ++i) {
            byte[] byArray2 = this.pad(byArray, 5, i);
            if ((i + byArray2.length) % this.blockSize != 0) {
                return false;
            }
            System.arraycopy(byArray2, 0, byArray, 5 + i, byArray2.length);
            try {
                if (byArray2.length == this.unpad(byArray, 5, i + byArray2.length)) continue;
                return false;
            }
            catch (WrongPaddingException wrongPaddingException) {
                return false;
            }
        }
        this.reset();
        return true;
    }

    public abstract void setup();

    public abstract byte[] pad(byte[] var1, int var2, int var3);

    public abstract int unpad(byte[] var1, int var2, int var3) throws WrongPaddingException;
}

