/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.CBC;
import gnu.javax.crypto.mode.CFB;
import gnu.javax.crypto.mode.CTR;
import gnu.javax.crypto.mode.EAX;
import gnu.javax.crypto.mode.ECB;
import gnu.javax.crypto.mode.ICM;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.OFB;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ModeFactory
implements Registry {
    private static Set names;

    private ModeFactory() {
    }

    public static IMode getInstance(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return null;
        }
        string = string.trim();
        IBlockCipher iBlockCipher = CipherFactory.getInstance(string2 = string2.trim());
        if (iBlockCipher == null) {
            return null;
        }
        return ModeFactory.getInstance(string, iBlockCipher, n);
    }

    public static IMode getInstance(String string, IBlockCipher iBlockCipher, int n) {
        boolean bl = false;
        Object object = iBlockCipher.blockSizes();
        while (object.hasNext() && !(bl = n == (Integer)object.next())) {
        }
        if (!bl) {
            throw new IllegalArgumentException("cipherBlockSize");
        }
        object = null;
        if (string.equalsIgnoreCase("ecb")) {
            object = new ECB(iBlockCipher, n);
        } else if (string.equalsIgnoreCase("ctr")) {
            object = new CTR(iBlockCipher, n);
        } else if (string.equalsIgnoreCase("icm")) {
            object = new ICM(iBlockCipher, n);
        } else if (string.equalsIgnoreCase("ofb")) {
            object = new OFB(iBlockCipher, n);
        } else if (string.equalsIgnoreCase("cbc")) {
            object = new CBC(iBlockCipher, n);
        } else if (string.equalsIgnoreCase("cfb")) {
            object = new CFB(iBlockCipher, n);
        } else if (string.equalsIgnoreCase("eax")) {
            object = new EAX(iBlockCipher, n);
        }
        if (object != null && !object.selfTest()) {
            throw new InternalError(object.name());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set getNames() {
        Class<ModeFactory> clazz = ModeFactory.class;
        synchronized (ModeFactory.class) {
            if (names == null) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("ecb");
                hashSet.add("ctr");
                hashSet.add("icm");
                hashSet.add("ofb");
                hashSet.add("cbc");
                hashSet.add("cfb");
                hashSet.add("eax");
                names = Collections.unmodifiableSet(hashSet);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }
}

