/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.BaseMac;
import gnu.javax.crypto.mac.UHash32;
import gnu.javax.crypto.prng.UMacGenerator;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class UMac32
extends BaseMac {
    public static final String NONCE_MATERIAL = "gnu.crypto.umac.nonce.material";
    private static final String TV1 = "455ED214A6909F20";
    private static final BigInteger MAX_NONCE_ITERATIONS = BigInteger.ONE.shiftLeft(128);
    static final int OUTPUT_LEN = 8;
    static final int L1_KEY_LEN = 1024;
    static final int KEY_LEN = 16;
    private static Boolean valid;
    private byte[] nonce;
    private UHash32 uhash32;
    private BigInteger nonceReuseCount;
    private transient byte[] K;

    public UMac32() {
        super("umac32");
    }

    private UMac32(UMac32 uMac32) {
        this();
        if (uMac32.K != null) {
            this.K = (byte[])uMac32.K.clone();
        }
        if (uMac32.nonce != null) {
            this.nonce = (byte[])uMac32.nonce.clone();
        }
        if (uMac32.uhash32 != null) {
            this.uhash32 = (UHash32)uMac32.uhash32.clone();
        }
        this.nonceReuseCount = uMac32.nonceReuseCount;
    }

    public Object clone() {
        return new UMac32(this);
    }

    public int macSize() {
        return 8;
    }

    public void init(Map map) throws InvalidKeyException, IllegalStateException {
        Object object;
        boolean bl;
        byte[] byArray = (byte[])map.get("gnu.crypto.mac.key.material");
        byte[] byArray2 = (byte[])map.get(NONCE_MATERIAL);
        boolean bl2 = byArray != null;
        boolean bl3 = bl = byArray2 != null;
        if (bl2) {
            if (byArray.length != 16) {
                throw new InvalidKeyException("Key length: " + String.valueOf(byArray.length));
            }
            this.K = byArray;
        } else if (this.K == null) {
            throw new InvalidKeyException("Null Key");
        }
        if (bl) {
            if (byArray2.length < 1 || byArray2.length > 16) {
                throw new IllegalArgumentException("Invalid Nonce length: " + String.valueOf(byArray2.length));
            }
            if (byArray2.length < 16) {
                object = new byte[16];
                System.arraycopy(byArray2, 0, object, 0, byArray2.length);
                this.nonce = (byte[])object;
            } else {
                this.nonce = byArray2;
            }
            this.nonceReuseCount = BigInteger.ZERO;
        } else if (this.nonce == null) {
            this.nonce = new byte[16];
            this.nonceReuseCount = BigInteger.ZERO;
        } else if (!bl2) {
            this.nonceReuseCount = this.nonceReuseCount.add(BigInteger.ONE);
            if (this.nonceReuseCount.compareTo(MAX_NONCE_ITERATIONS) >= 0) {
                throw new InvalidKeyException("Null Key and unusable old Nonce");
            }
            object = new BigInteger(1, this.nonce);
            byArray2 = ((BigInteger)(object = ((BigInteger)object).add(BigInteger.ONE).mod(MAX_NONCE_ITERATIONS))).toByteArray();
            if (byArray2.length == 16) {
                this.nonce = byArray2;
            } else if (byArray2.length < 16) {
                this.nonce = new byte[16];
                System.arraycopy(byArray2, 0, this.nonce, 16 - byArray2.length, byArray2.length);
            } else {
                this.nonce = new byte[16];
                System.arraycopy(byArray2, byArray2.length - 16, this.nonce, 0, 16);
            }
        } else {
            this.nonceReuseCount = BigInteger.ZERO;
        }
        if (this.uhash32 == null) {
            this.uhash32 = new UHash32();
        }
        object = new HashMap();
        object.put("gnu.crypto.mac.key.material", this.K);
        this.uhash32.init((Map)object);
    }

    public void update(byte by) {
        this.uhash32.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.uhash32.update(byArray, n, n2);
    }

    public byte[] digest() {
        byte[] byArray = this.uhash32.digest();
        byte[] byArray2 = this.pdf();
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray;
    }

    public void reset() {
        if (this.uhash32 != null) {
            this.uhash32.reset();
        }
    }

    public boolean selfTest() {
        if (valid == null) {
            byte[] byArray;
            try {
                byArray = "abcdefghijklmnop".getBytes("ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("ASCII not supported");
            }
            byte[] byArray2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            UMac32 uMac32 = new UMac32();
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("gnu.crypto.mac.key.material", byArray);
            hashMap.put(NONCE_MATERIAL, byArray2);
            try {
                uMac32.init(hashMap);
            }
            catch (InvalidKeyException invalidKeyException) {
                invalidKeyException.printStackTrace(System.err);
                return false;
            }
            byte[] byArray3 = new byte[128];
            byArray3[0] = -128;
            uMac32.update(byArray3, 0, 128);
            byte[] byArray4 = uMac32.digest();
            valid = TV1.equals(Util.toString(byArray4));
        }
        return valid;
    }

    private byte[] pdf() {
        BigInteger bigInteger = new BigInteger(1, this.nonce);
        int n = bigInteger.testBit(0) ? 1 : 0;
        bigInteger = bigInteger.clearBit(0);
        UMacGenerator uMacGenerator = new UMacGenerator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.cipher.key.material", this.K);
        hashMap.put("gnu.crypto.prng.umac.index", 128);
        uMacGenerator.init(hashMap);
        byte[] byArray = new byte[16];
        try {
            uMacGenerator.nextBytes(byArray, 0, 16);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace(System.err);
            throw new RuntimeException(String.valueOf(illegalStateException));
        }
        catch (LimitReachedException limitReachedException) {
            limitReachedException.printStackTrace(System.err);
            throw new RuntimeException(String.valueOf(limitReachedException));
        }
        IBlockCipher iBlockCipher = CipherFactory.getInstance("aes");
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        try {
            iBlockCipher.init(hashMap);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace(System.err);
            throw new RuntimeException(String.valueOf(invalidKeyException));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace(System.err);
            throw new RuntimeException(String.valueOf(illegalStateException));
        }
        byte[] byArray2 = new byte[16];
        iBlockCipher.encryptBlock(this.nonce, 0, byArray2, 0);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray2, n, byArray3, 0, 8);
        return byArray3;
    }
}

