/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.mac.BaseMac;
import gnu.javax.crypto.prng.UMacGenerator;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class UHash32
extends BaseMac {
    private static final BigInteger PRIME_19 = BigInteger.valueOf(524287L);
    private static final BigInteger PRIME_32 = BigInteger.valueOf(0xFFFFFFFBL);
    private static final BigInteger PRIME_36 = BigInteger.valueOf(0xFFFFFFFFBL);
    private static final BigInteger PRIME_64 = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -59});
    private static final BigInteger PRIME_128 = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 97});
    static final BigInteger TWO = BigInteger.valueOf(2L);
    static final long BOUNDARY = TWO.shiftLeft(17).longValue();
    static final BigInteger LOWER_RANGE = TWO.pow(64).subtract(TWO.pow(32));
    static final BigInteger UPPER_RANGE = TWO.pow(128).subtract(TWO.pow(96));
    static final byte[] ALL_ZEROES = new byte[32];
    int streams;
    L1Hash32[] l1hash;

    public UHash32() {
        super("uhash32");
    }

    private UHash32(UHash32 uHash32) {
        this();
        this.streams = uHash32.streams;
        if (uHash32.l1hash != null) {
            this.l1hash = new L1Hash32[uHash32.streams];
            for (int i = 0; i < uHash32.streams; ++i) {
                if (uHash32.l1hash[i] == null) continue;
                this.l1hash[i] = (L1Hash32)uHash32.l1hash[i].clone();
            }
        }
    }

    static final BigInteger prime(int n) {
        switch (n) {
            case 19: {
                return PRIME_19;
            }
            case 32: {
                return PRIME_32;
            }
            case 36: {
                return PRIME_36;
            }
            case 64: {
                return PRIME_64;
            }
            case 128: {
                return PRIME_128;
            }
        }
        throw new IllegalArgumentException("Undefined prime(" + String.valueOf(n) + ")");
    }

    public Object clone() {
        return new UHash32(this);
    }

    public int macSize() {
        return 8;
    }

    public void init(Map map) throws InvalidKeyException, IllegalStateException {
        byte[] byArray = (byte[])map.get("gnu.crypto.mac.key.material");
        if (byArray == null) {
            throw new InvalidKeyException("Null Key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException("Invalid Key length: " + String.valueOf(byArray.length));
        }
        this.streams = 2;
        UMacGenerator uMacGenerator = new UMacGenerator();
        UMacGenerator uMacGenerator2 = new UMacGenerator();
        UMacGenerator uMacGenerator3 = new UMacGenerator();
        UMacGenerator uMacGenerator4 = new UMacGenerator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        hashMap.put("gnu.crypto.prng.umac.index", 0);
        uMacGenerator.init(hashMap);
        hashMap.put("gnu.crypto.prng.umac.index", 1);
        uMacGenerator2.init(hashMap);
        hashMap.put("gnu.crypto.prng.umac.index", 2);
        uMacGenerator3.init(hashMap);
        hashMap.put("gnu.crypto.prng.umac.index", 3);
        uMacGenerator4.init(hashMap);
        byte[] byArray2 = new byte[1024 + (this.streams - 1) * 16];
        try {
            uMacGenerator.nextBytes(byArray2, 0, byArray2.length);
        }
        catch (LimitReachedException limitReachedException) {
            limitReachedException.printStackTrace(System.err);
            throw new RuntimeException("KDF for L1Key reached limit");
        }
        this.l1hash = new L1Hash32[this.streams];
        for (int i = 0; i < this.streams; ++i) {
            byte[] byArray3 = new byte[1024];
            System.arraycopy(byArray2, i * 16, byArray3, 0, 1024);
            byte[] byArray4 = new byte[24];
            try {
                uMacGenerator2.nextBytes(byArray4, 0, 24);
            }
            catch (LimitReachedException limitReachedException) {
                limitReachedException.printStackTrace(System.err);
                throw new RuntimeException("KDF for L2Key reached limit");
            }
            byte[] byArray5 = new byte[64];
            try {
                uMacGenerator3.nextBytes(byArray5, 0, 64);
            }
            catch (LimitReachedException limitReachedException) {
                limitReachedException.printStackTrace(System.err);
                throw new RuntimeException("KDF for L3Key1 reached limit");
            }
            byte[] byArray6 = new byte[4];
            try {
                uMacGenerator4.nextBytes(byArray6, 0, 4);
            }
            catch (LimitReachedException limitReachedException) {
                limitReachedException.printStackTrace(System.err);
                throw new RuntimeException("KDF for L3Key2 reached limit");
            }
            L1Hash32 l1Hash32 = new L1Hash32();
            l1Hash32.init(byArray3, byArray4, byArray5, byArray6);
            this.l1hash[i] = l1Hash32;
        }
    }

    public void update(byte by) {
        for (int i = 0; i < this.streams; ++i) {
            this.l1hash[i].update(by);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.update(byArray[n + i]);
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[8];
        for (int i = 0; i < this.streams; ++i) {
            byte[] byArray2 = this.l1hash[i].digest();
            System.arraycopy(byArray2, 0, byArray, 4 * i, 4);
        }
        this.reset();
        return byArray;
    }

    public void reset() {
        for (int i = 0; i < this.streams; ++i) {
            this.l1hash[i].reset();
        }
    }

    public boolean selfTest() {
        return true;
    }

    class L3Hash32
    implements Cloneable {
        private static final long PRIME_36 = 0xFFFFFFFFBL;
        private int[] k = new int[9];

        L3Hash32(byte[] byArray, byte[] byArray2) {
            if (byArray.length != 64) {
                throw new ExceptionInInitializerError("K1 length is not 64");
            }
            if (byArray2.length != 4) {
                throw new ExceptionInInitializerError("K2 length is not 4");
            }
            int n = 0;
            for (int i = 0; i < 8; ++i) {
                long l = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                this.k[i] = (int)(l % 0xFFFFFFFFBL);
            }
            this.k[8] = byArray2[0] << 24 | (byArray2[1] & 0xFF) << 16 | (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
        }

        private L3Hash32(int[] nArray) {
            this.k = nArray;
        }

        public Object clone() {
            return new L3Hash32((int[])this.k.clone());
        }

        byte[] digest(byte[] byArray) {
            int n;
            if (byArray.length != 16) {
                throw new IllegalArgumentException("M length is not 16");
            }
            long l = 0L;
            int n2 = 0;
            for (n = 0; n < 8; ++n) {
                long l2 = ((long)byArray[n2++] & 0xFFL) << 8 | (long)byArray[n2++] & 0xFFL;
                l += l2 * ((long)this.k[n] & 0xFFFFFFFFL) % 0xFFFFFFFFBL;
            }
            n = (int)l ^ this.k[8];
            return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        }
    }

    class L2Hash32
    implements Cloneable {
        private BigInteger k64;
        private BigInteger k128;
        private BigInteger y;
        private boolean highBound;
        private long bytesSoFar;
        private ByteArrayOutputStream buffer;

        L2Hash32(byte[] byArray) {
            if (byArray.length != 24) {
                throw new ExceptionInInitializerError("K length is not 24");
            }
            int n = 0;
            this.k64 = new BigInteger(1, new byte[]{(byte)(byArray[n++] & 1), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 1), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF)});
            this.k128 = new BigInteger(1, new byte[]{(byte)(byArray[n++] & 1), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 1), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 1), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 1), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF), (byte)(byArray[n++] & 0xFF)});
            this.y = BigInteger.ONE;
            this.highBound = false;
            this.bytesSoFar = 0L;
        }

        private L2Hash32(L2Hash32 l2Hash32) {
            this.k64 = l2Hash32.k64;
            this.k128 = l2Hash32.k128;
            this.y = l2Hash32.y;
            this.highBound = l2Hash32.highBound;
            this.bytesSoFar = l2Hash32.bytesSoFar;
            if (l2Hash32.buffer != null) {
                byte[] byArray = l2Hash32.buffer.toByteArray();
                this.buffer = new ByteArrayOutputStream();
                this.buffer.write(byArray, 0, byArray.length);
            }
        }

        public Object clone() {
            return new L2Hash32(this);
        }

        void update(byte[] byArray, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            if (!this.highBound) {
                this.poly(64, LOWER_RANGE, this.k64, byArray, n, 8);
                this.bytesSoFar += 8L;
                boolean bl = this.highBound = this.bytesSoFar > BOUNDARY;
                if (this.highBound) {
                    this.poly(128, UPPER_RANGE, this.k128, this.yTo16bytes(), 0, 16);
                    this.buffer = new ByteArrayOutputStream();
                }
                this.update(byArray, n + 8, n2 - 8);
            } else {
                this.buffer.write(byArray, n, n2);
                if (this.buffer.size() > 16) {
                    byte[] byArray2 = this.buffer.toByteArray();
                    this.poly(128, UPPER_RANGE, this.k128, byArray2, 0, 16);
                    if (byArray2.length > 16) {
                        this.buffer.write(byArray2, 16, byArray2.length - 16);
                    }
                }
            }
        }

        byte[] digest() {
            byte[] byArray;
            if (this.highBound) {
                byArray = this.buffer.toByteArray();
                byte[] byArray2 = new byte[16];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray.length] = -128;
                this.poly(128, UPPER_RANGE, this.k128, byArray2, 0, 16);
            }
            byArray = this.yTo16bytes();
            this.reset();
            return byArray;
        }

        void reset() {
            this.y = BigInteger.ONE;
            this.highBound = false;
            this.bytesSoFar = 0L;
            if (this.buffer != null) {
                this.buffer.reset();
            }
        }

        private byte[] yTo16bytes() {
            byte[] byArray = this.y.toByteArray();
            byte[] byArray2 = new byte[16];
            if (byArray.length > 16) {
                System.arraycopy(byArray, byArray.length - 16, byArray2, 0, 16);
            } else {
                System.arraycopy(byArray, 0, byArray2, 16 - byArray.length, byArray.length);
            }
            return byArray2;
        }

        private void poly(int n, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2, int n3) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            BigInteger bigInteger3 = UHash32.prime(n);
            BigInteger bigInteger4 = TWO.pow(n).subtract(bigInteger3);
            BigInteger bigInteger5 = bigInteger3.subtract(BigInteger.ONE);
            BigInteger bigInteger6 = new BigInteger(1, byArray2);
            if (bigInteger6.compareTo(bigInteger) >= 0) {
                this.y = this.y.multiply(bigInteger2).add(bigInteger5).mod(bigInteger3);
                this.y = this.y.multiply(bigInteger2).add(bigInteger6.subtract(bigInteger4)).mod(bigInteger3);
            } else {
                this.y = this.y.multiply(bigInteger2).add(bigInteger6).mod(bigInteger3);
            }
        }
    }

    class L1Hash32
    implements Cloneable {
        private int[] key = new int[256];
        private byte[] buffer = new byte[1024];
        private int count = 0;
        private ByteArrayOutputStream Y = new ByteArrayOutputStream();
        private long totalCount = 0L;
        private L2Hash32 l2hash;
        private L3Hash32 l3hash;

        L1Hash32() {
        }

        private L1Hash32(L1Hash32 l1Hash32) {
            this();
            System.arraycopy(l1Hash32.key, 0, this.key, 0, l1Hash32.key.length);
            System.arraycopy(l1Hash32.buffer, 0, this.buffer, 0, l1Hash32.count);
            this.count = l1Hash32.count;
            byte[] byArray = l1Hash32.Y.toByteArray();
            this.Y.write(byArray, 0, byArray.length);
            this.totalCount = l1Hash32.totalCount;
            if (l1Hash32.l2hash != null) {
                this.l2hash = (L2Hash32)l1Hash32.l2hash.clone();
            }
            if (l1Hash32.l3hash != null) {
                this.l3hash = (L3Hash32)l1Hash32.l3hash.clone();
            }
        }

        public Object clone() {
            return new L1Hash32(this);
        }

        public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                this.key[i] = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            }
            this.l2hash = new L2Hash32(byArray2);
            this.l3hash = new L3Hash32(byArray3, byArray4);
        }

        public void update(byte by) {
            this.buffer[this.count] = by;
            ++this.count;
            ++this.totalCount;
            if (this.count >= 1024) {
                byte[] byArray = this.nh32(1024);
                this.Y.write(byArray, 0, 8);
                this.count = 0;
                if (this.Y.size() == 16) {
                    byte[] byArray2 = this.Y.toByteArray();
                    this.Y.reset();
                    this.l2hash.update(byArray2, 0, 16);
                }
            }
        }

        public byte[] digest() {
            byte[] byArray;
            byte[] byArray2;
            if (this.count != 0) {
                if (this.count % 32 != 0) {
                    int n = 32 * ((this.count + 31) / 32);
                    System.arraycopy(ALL_ZEROES, 0, this.buffer, this.count, n - this.count);
                    this.count += n - this.count;
                }
                byArray2 = this.nh32(this.count);
                this.Y.write(byArray2, 0, 8);
            }
            byArray2 = this.Y.toByteArray();
            this.Y.reset();
            if (this.totalCount <= 1024L) {
                if (byArray2.length == 0) {
                    byArray = this.l2hash.digest();
                } else {
                    byArray = new byte[16];
                    System.arraycopy(byArray2, 0, byArray, 8, 8);
                }
            } else {
                if (byArray2.length != 0) {
                    this.l2hash.update(byArray2, 0, byArray2.length);
                }
                byArray = this.l2hash.digest();
            }
            byte[] byArray3 = this.l3hash.digest(byArray);
            this.reset();
            return byArray3;
        }

        public void reset() {
            this.count = 0;
            this.Y.reset();
            this.totalCount = 0L;
            if (this.l2hash != null) {
                this.l2hash.reset();
            }
        }

        private byte[] nh32(int n) {
            int n2;
            int n3 = n / 4;
            int[] nArray = new int[n3];
            int n4 = 0;
            n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.buffer[n4++] << 24 | (this.buffer[n4++] & 0xFF) << 16 | (this.buffer[n4++] & 0xFF) << 8 | this.buffer[n4++] & 0xFF;
            }
            long l = (long)n * 8L;
            for (n2 = 0; n2 < n3; n2 += 8) {
                l += ((long)(nArray[n2 + 0] + this.key[n2 + 0]) & 0xFFFFFFFFL) * ((long)(nArray[n2 + 4] + this.key[n2 + 4]) & 0xFFFFFFFFL);
                l += ((long)(nArray[n2 + 1] + this.key[n2 + 1]) & 0xFFFFFFFFL) * ((long)(nArray[n2 + 5] + this.key[n2 + 5]) & 0xFFFFFFFFL);
                l += ((long)(nArray[n2 + 2] + this.key[n2 + 2]) & 0xFFFFFFFFL) * ((long)(nArray[n2 + 6] + this.key[n2 + 6]) & 0xFFFFFFFFL);
                l += ((long)(nArray[n2 + 3] + this.key[n2 + 3]) & 0xFFFFFFFFL) * ((long)(nArray[n2 + 7] + this.key[n2 + 7]) & 0xFFFFFFFFL);
            }
            return new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        }
    }
}

