/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.mac.BaseMac;
import java.security.InvalidKeyException;
import java.util.Map;

public class TMMH16
extends BaseMac
implements Cloneable {
    public static final String TAG_LENGTH = "gnu.crypto.mac.tmmh.tag.length";
    public static final String KEYSTREAM = "gnu.crypto.mac.tmmh.keystream";
    public static final String PREFIX = "gnu.crypto.mac.tmmh.prefix";
    private static final int P = 65537;
    private static Boolean valid;
    private int tagWords = 0;
    private IRandom keystream = null;
    private byte[] prefix;
    private long keyWords;
    private long msgLength;
    private long msgWords;
    private int[] context;
    private int[] K0;
    private int[] Ki;
    private int Mi;

    public TMMH16() {
        super("tmmh16");
    }

    public int macSize() {
        return this.tagWords * 2;
    }

    public void init(Map map) throws InvalidKeyException, IllegalStateException {
        int n = 0;
        Integer n2 = (Integer)map.get(TAG_LENGTH);
        if (n2 == null) {
            if (this.tagWords == 0) {
                throw new IllegalArgumentException(TAG_LENGTH);
            }
        } else {
            n = n2;
            if (n < 2 || n % 2 != 0) {
                throw new IllegalArgumentException(TAG_LENGTH);
            }
            if (n > 64) {
                throw new IllegalArgumentException(TAG_LENGTH);
            }
            this.tagWords = n / 2;
            this.K0 = new int[this.tagWords];
            this.Ki = new int[this.tagWords];
            this.context = new int[this.tagWords];
        }
        this.prefix = (byte[])map.get(PREFIX);
        if (this.prefix == null) {
            this.prefix = new byte[this.tagWords * 2];
        } else if (this.prefix.length != this.tagWords * 2) {
            throw new IllegalArgumentException(PREFIX);
        }
        IRandom iRandom = (IRandom)map.get(KEYSTREAM);
        if (iRandom == null) {
            if (this.keystream == null) {
                throw new IllegalArgumentException(KEYSTREAM);
            }
        } else {
            this.keystream = iRandom;
        }
        this.reset();
        for (int i = 0; i < this.tagWords; ++i) {
            this.Ki[i] = this.K0[i] = this.getNextKeyWord(this.keystream);
        }
    }

    public void update(byte by) {
        this.update(by, this.keystream);
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.update(byArray[n + i], this.keystream);
        }
    }

    public byte[] digest() {
        return this.digest(this.keystream);
    }

    public void reset() {
        this.keyWords = 0L;
        this.msgWords = 0L;
        this.msgLength = 0L;
        this.Mi = 0;
        for (int i = 0; i < this.tagWords; ++i) {
            this.context[i] = 0;
        }
    }

    public boolean selfTest() {
        if (valid == null) {
            valid = Boolean.TRUE;
        }
        return valid;
    }

    public Object clone() throws CloneNotSupportedException {
        TMMH16 tMMH16 = (TMMH16)super.clone();
        if (this.keystream != null) {
            tMMH16.keystream = (IRandom)this.keystream.clone();
        }
        if (this.prefix != null) {
            tMMH16.prefix = (byte[])this.prefix.clone();
        }
        if (this.context != null) {
            tMMH16.context = (int[])this.context.clone();
        }
        if (this.K0 != null) {
            tMMH16.K0 = (int[])this.K0.clone();
        }
        if (this.Ki != null) {
            tMMH16.Ki = (int[])this.Ki.clone();
        }
        return tMMH16;
    }

    public void update(byte by, IRandom iRandom) {
        this.Mi <<= 8;
        this.Mi |= by & 0xFF;
        ++this.msgLength;
        if (this.msgLength % 2L == 0L) {
            ++this.msgWords;
            System.arraycopy(this.Ki, 1, this.Ki, 0, this.tagWords - 1);
            this.Ki[this.tagWords - 1] = this.getNextKeyWord(iRandom);
            for (int i = 0; i < this.tagWords; ++i) {
                long l = (long)this.context[i] & 0xFFFFFFFFL;
                this.context[i] = (int)(l += (long)(this.Ki[i] * this.Mi));
            }
            this.Mi = 0;
        }
    }

    public void update(byte[] byArray, int n, int n2, IRandom iRandom) {
        for (int i = 0; i < n2; ++i) {
            this.update(byArray[n + i], iRandom);
        }
    }

    public byte[] digest(IRandom iRandom) {
        this.doFinalRound(iRandom);
        byte[] byArray = new byte[this.tagWords * 2];
        int n = 0;
        for (int i = 0; i < this.tagWords; ++i) {
            byArray[n] = (byte)(this.context[i] >>> 8 ^ this.prefix[n]);
            byArray[++n] = (byte)(this.context[i] ^ this.prefix[n]);
            ++n;
        }
        this.reset();
        return byArray;
    }

    private int getNextKeyWord(IRandom iRandom) {
        int n = 0;
        try {
            n = (iRandom.nextByte() & 0xFF) << 8 | iRandom.nextByte() & 0xFF;
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException(String.valueOf(limitReachedException));
        }
        ++this.keyWords;
        return n;
    }

    private void doFinalRound(IRandom iRandom) {
        long l = this.msgLength;
        while (this.msgLength % 2L != 0L) {
            this.update((byte)0, iRandom);
        }
        for (int i = 0; i < this.tagWords; ++i) {
            long l2 = (long)this.context[i] & 0xFFFFFFFFL;
            l2 += (long)this.K0[i] * l;
            this.context[i] = (int)(l2 %= 65537L);
        }
    }
}

