/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.javax.crypto.kwa.AESKeyWrap;
import gnu.javax.crypto.kwa.BaseKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.IKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.TripleDESKeyWrap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyWrappingAlgorithmFactory {
    private static Set names;

    private KeyWrappingAlgorithmFactory() {
    }

    public static final IKeyWrappingAlgorithm getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseKeyWrappingAlgorithm baseKeyWrappingAlgorithm = null;
        if (string.equalsIgnoreCase("kw-aes") || string.equalsIgnoreCase("kw-aes128") || string.equalsIgnoreCase("kw-aes192") || string.equalsIgnoreCase("kw-aes256") || string.equalsIgnoreCase("kw-rijndael")) {
            baseKeyWrappingAlgorithm = new AESKeyWrap();
        } else if (string.equalsIgnoreCase("kw-tripledes") || string.equalsIgnoreCase("kw-desede")) {
            baseKeyWrappingAlgorithm = new TripleDESKeyWrap();
        }
        return baseKeyWrappingAlgorithm;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("kw-aes");
            hashSet.add("kw-aes128");
            hashSet.add("kw-aes192");
            hashSet.add("kw-aes256");
            hashSet.add("kw-rijndael");
            hashSet.add("kw-tripledes");
            hashSet.add("kw-desede");
            names = Collections.unmodifiableSet(hashSet);
        }
        return names;
    }
}

