/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mac.MacOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;

public final class AuthenticatedEntry
extends MaskableEnvelopeEntry
implements Registry {
    public static final int TYPE = 2;

    public AuthenticatedEntry(String string, int n, Properties properties) {
        super(2, properties);
        if (n <= 0) {
            throw new IllegalArgumentException("invalid mac length");
        }
        this.properties.put("mac", string);
        this.properties.put("maclen", String.valueOf(n));
        this.setMasked(false);
    }

    private AuthenticatedEntry() {
        super(2);
        this.setMasked(true);
    }

    public static AuthenticatedEntry decode(DataInputStream dataInputStream) throws IOException {
        AuthenticatedEntry authenticatedEntry = new AuthenticatedEntry();
        authenticatedEntry.properties.decode(dataInputStream);
        if (!authenticatedEntry.properties.containsKey("mac")) {
            throw new MalformedKeyringException("no mac specified");
        }
        if (!authenticatedEntry.properties.containsKey("maclen")) {
            throw new MalformedKeyringException("no mac length specified");
        }
        return authenticatedEntry;
    }

    public void authenticate(byte[] byArray) throws IOException, InvalidKeyException {
        if (this.isMasked()) {
            throw new IllegalStateException("entry is masked");
        }
        IMac iMac = this.getMac(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        MacOutputStream macOutputStream = new MacOutputStream(byteArrayOutputStream, iMac);
        DataOutputStream dataOutputStream = new DataOutputStream(macOutputStream);
        for (Entry entry : this.entries) {
            entry.encode(dataOutputStream);
        }
        byteArrayOutputStream.write(iMac.digest());
        this.payload = byteArrayOutputStream.toByteArray();
    }

    public void verify(byte[] byArray) throws InvalidKeyException {
        if (!this.isMasked() || this.payload == null) {
            return;
        }
        IMac iMac = this.getMac(byArray);
        iMac.update(this.payload, 0, this.payload.length - iMac.macSize());
        byte[] byArray2 = new byte[iMac.macSize()];
        System.arraycopy(this.payload, this.payload.length - byArray2.length, byArray2, 0, byArray2.length);
        if (!Arrays.equals(byArray2, iMac.digest())) {
            throw new IllegalArgumentException("MAC verification failed");
        }
        try {
            int n = this.payload.length - iMac.macSize();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.payload, 0, n);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.decodeEnvelope(dataInputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("malformed keyring fragment");
        }
        this.setMasked(false);
        this.payload = null;
    }

    protected void encodePayload() throws IOException {
        if (this.payload == null) {
            throw new IllegalStateException("not authenticated");
        }
    }

    private IMac getMac(byte[] byArray) throws InvalidKeyException {
        IMac iMac = MacFactory.getInstance(this.properties.get("mac"));
        if (iMac == null) {
            throw new IllegalArgumentException("no such mac: " + this.properties.get("mac"));
        }
        int n = 0;
        if (!this.properties.containsKey("maclen")) {
            throw new IllegalArgumentException("no MAC length");
        }
        try {
            n = Integer.parseInt(this.properties.get("maclen"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("bad MAC length");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.mac.key.material", byArray);
        hashMap.put("gnu.crypto.mac.truncated.size", n);
        iMac.init(hashMap);
        return iMac;
    }
}

