/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.Registry;
import gnu.javax.crypto.key.srp6.SRPAlgorithm;
import gnu.javax.crypto.key.srp6.SRPKey;
import gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec;
import java.math.BigInteger;
import java.security.PublicKey;

public class SRPPublicKey
extends SRPKey
implements PublicKey {
    private final BigInteger Y;

    public SRPPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(bigInteger, bigInteger2);
        SRPAlgorithm.checkParams(bigInteger, bigInteger2);
        this.Y = bigInteger3;
    }

    SRPPublicKey(BigInteger[] bigIntegerArray) {
        super(bigIntegerArray[0], bigIntegerArray[1]);
        this.Y = bigIntegerArray[2];
    }

    public static SRPPublicKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_SRP_PUBLIC_KEY[0]) {
            SRPKeyPairRawCodec sRPKeyPairRawCodec = new SRPKeyPairRawCodec();
            return (SRPPublicKey)sRPKeyPairRawCodec.decodePublicKey(byArray);
        }
        throw new IllegalArgumentException("magic");
    }

    public BigInteger getY() {
        return this.Y;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new SRPKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("format");
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SRPPublicKey)) {
            return false;
        }
        SRPPublicKey sRPPublicKey = (SRPPublicKey)object;
        return super.equals(sRPPublicKey) && this.Y.equals(sRPPublicKey.getY());
    }
}

