/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.hash.Sha160;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RFC2631 {
    public static final int DH_PARAMS_SEED = 0;
    public static final int DH_PARAMS_COUNTER = 1;
    public static final int DH_PARAMS_Q = 2;
    public static final int DH_PARAMS_P = 3;
    public static final int DH_PARAMS_J = 4;
    public static final int DH_PARAMS_G = 5;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Sha160 sha = new Sha160();
    private int m;
    private int L;
    private SecureRandom rnd = null;
    private PRNG prng = null;

    public RFC2631(int n, int n2, SecureRandom secureRandom) {
        this.m = n;
        this.L = n2;
        this.rnd = secureRandom;
    }

    public BigInteger[] generateParameters() {
        BigInteger bigInteger;
        int n;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        byte[] byArray = new byte[this.m / 8];
        int n2 = (this.m + 159) / 160;
        int n3 = (this.L + 159) / 160;
        int n4 = (this.L + 1023) / 1024;
        block0: while (true) {
            int n5;
            this.nextRandomBytes(byArray);
            bigInteger3 = new BigInteger(1, byArray).setBit(this.m - 1).setBit(0);
            BigInteger bigInteger4 = BigInteger.ZERO;
            for (n5 = 0; n5 < n2; ++n5) {
                byte[] byArray2 = bigInteger3.add(BigInteger.valueOf(n5)).toByteArray();
                byte[] byArray3 = bigInteger3.add(BigInteger.valueOf(n2 + n5)).toByteArray();
                this.sha.update(byArray2, 0, byArray2.length);
                byArray2 = this.sha.digest();
                this.sha.update(byArray3, 0, byArray3.length);
                byArray3 = this.sha.digest();
                for (int i = 0; i < byArray2.length; ++i) {
                    int n6 = i;
                    byArray2[n6] = (byte)(byArray2[n6] ^ byArray3[i]);
                }
                bigInteger4 = bigInteger4.add(new BigInteger(1, byArray2).multiply(TWO.pow(160 * n5)));
            }
            bigInteger2 = bigInteger4.setBit(this.m - 1).setBit(0);
            if (!bigInteger2.isProbablePrime(80)) continue;
            n = 0;
            do {
                BigInteger bigInteger5 = bigInteger3.add(BigInteger.valueOf(2 * n2)).add(BigInteger.valueOf(n3 * n));
                BigInteger bigInteger6 = BigInteger.ZERO;
                for (n5 = 0; n5 < n3; ++n5) {
                    byte[] byArray4 = bigInteger5.toByteArray();
                    this.sha.update(byArray4, 0, byArray4.length);
                    byArray4 = this.sha.digest();
                    bigInteger6 = bigInteger6.add(new BigInteger(1, byArray4).multiply(TWO.pow(160 * n5)));
                }
                BigInteger bigInteger7 = bigInteger6.mod(TWO.pow(this.L));
                BigInteger bigInteger8 = bigInteger7.setBit(this.L - 1);
                bigInteger = bigInteger8.add(BigInteger.ONE).subtract(bigInteger8.mod(TWO.multiply(bigInteger2)));
                if (bigInteger.isProbablePrime(80)) break block0;
            } while (++n < 4096 * n4);
        }
        BigInteger bigInteger9 = bigInteger.subtract(BigInteger.ONE).divide(bigInteger2);
        BigInteger bigInteger10 = TWO;
        BigInteger bigInteger11 = bigInteger.subtract(BigInteger.ONE);
        BigInteger bigInteger12 = TWO;
        while (bigInteger10.compareTo(bigInteger11) < 0 && (bigInteger12 = bigInteger10.modPow(bigInteger9, bigInteger)).equals(BigInteger.ONE)) {
            bigInteger10 = bigInteger10.add(BigInteger.ONE);
        }
        return new BigInteger[]{bigInteger3, BigInteger.valueOf(n), bigInteger2, bigInteger, bigInteger9, bigInteger12};
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

