/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec;
import gnu.javax.crypto.key.dh.DHKeyPairRawCodec;
import gnu.javax.crypto.key.dh.GnuDHKey;
import java.math.BigInteger;
import java.security.AccessController;
import javax.crypto.interfaces.DHPrivateKey;

public class GnuDHPrivateKey
extends GnuDHKey
implements DHPrivateKey {
    private final BigInteger x;
    private transient String str;

    public GnuDHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(1, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public GnuDHPrivateKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(n == 4 ? 3 : n, bigInteger, bigInteger2, bigInteger3);
        this.x = bigInteger4;
    }

    public static GnuDHPrivateKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_DH_PRIVATE_KEY[0]) {
            try {
                return (GnuDHPrivateKey)new DHKeyPairRawCodec().decodePrivateKey(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return (GnuDHPrivateKey)new DHKeyPairPKCS8Codec().decodePrivateKey(byArray);
    }

    public BigInteger getX() {
        return this.x;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new DHKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 3: {
                byArray = new DHKeyPairPKCS8Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + n);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DHPrivateKey)) {
            return false;
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)object;
        return super.equals(dHPrivateKey) && this.x.equals(dHPrivateKey.getX());
    }

    public String toString() {
        if (this.str == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + string + "x=0x" + "**...*" + string + ")";
        }
        return this.str;
    }
}

