/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.prng.IRandom;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.dh.DiffieHellmanKeyAgreement;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;

public class DiffieHellmanReceiver
extends DiffieHellmanKeyAgreement {
    private BigInteger y;

    protected void engineInit(Map map) throws KeyAgreementException {
        Object v = map.get("gnu.crypto.dh.ka.prng");
        this.rnd = null;
        this.irnd = null;
        if (v instanceof SecureRandom) {
            this.rnd = (SecureRandom)v;
        } else if (v instanceof IRandom) {
            this.irnd = (IRandom)v;
        }
        this.ownerKey = (DHPrivateKey)map.get("gnu.crypto.dh.ka.owner.private.key");
        if (this.ownerKey == null) {
            throw new KeyAgreementException("missing owner's private key");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    private OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger = incomingMessage.readMPI();
        if (bigInteger == null) {
            throw new KeyAgreementException("missing message (1)");
        }
        BigInteger bigInteger2 = this.ownerKey.getParams().getP();
        BigInteger bigInteger3 = this.ownerKey.getParams().getG();
        BigInteger bigInteger4 = bigInteger2.subtract(TWO);
        byte[] byArray = new byte[(bigInteger4.bitLength() + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
            this.y = new BigInteger(1, byArray);
        } while (this.y.compareTo(TWO) < 0 || this.y.compareTo(bigInteger4) > 0);
        this.ZZ = bigInteger.modPow(this.y, bigInteger2);
        this.complete = true;
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeMPI(bigInteger3.modPow(this.y, bigInteger2));
        return outgoingMessage;
    }
}

