/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public DHKeyPairGeneratorSpi() {
        super("dh");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("gnu.crypto.dh.L", Integer.valueOf(n));
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.dh.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.dh.encoding", Integer.valueOf(4));
        this.adaptee.setup(hashMap);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof DHGenParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            hashMap.put("gnu.crypto.dh.params", algorithmParameterSpec);
        }
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.dh.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.dh.encoding", 4);
        this.adaptee.setup(hashMap);
    }
}

