/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec;
import gnu.javax.crypto.key.dh.DHKeyPairX509Codec;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPublicKeySpec) {
            DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
            BigInteger bigInteger = dHPublicKeySpec.getP();
            BigInteger bigInteger2 = dHPublicKeySpec.getG();
            BigInteger bigInteger3 = dHPublicKeySpec.getY();
            return new GnuDHPublicKey(2, null, bigInteger, bigInteger2, bigInteger3);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            byte[] byArray = x509EncodedKeySpec.getEncoded();
            try {
                PublicKey publicKey = new DHKeyPairX509Codec().decodePublicKey(byArray);
                return publicKey;
            }
            catch (RuntimeException runtimeException) {
                InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
                invalidKeySpecException.initCause(runtimeException);
                throw invalidKeySpecException;
            }
        }
        throw new InvalidKeySpecException("Unsupported (public) key specification");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
            BigInteger bigInteger = dHPrivateKeySpec.getP();
            BigInteger bigInteger2 = dHPrivateKeySpec.getG();
            BigInteger bigInteger3 = dHPrivateKeySpec.getX();
            return new GnuDHPrivateKey(3, null, bigInteger, bigInteger2, bigInteger3);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            byte[] byArray = pKCS8EncodedKeySpec.getEncoded();
            try {
                PrivateKey privateKey = new DHKeyPairPKCS8Codec().decodePrivateKey(byArray);
                return privateKey;
            }
            catch (RuntimeException runtimeException) {
                InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
                invalidKeySpecException.initCause(runtimeException);
                throw invalidKeySpecException;
            }
        }
        throw new InvalidKeySpecException("Unsupported (private) key specification");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DHPublicKey) {
            if (clazz.isAssignableFrom(DHPublicKeySpec.class)) {
                DHPublicKey dHPublicKey = (DHPublicKey)key;
                BigInteger bigInteger = dHPublicKey.getParams().getP();
                BigInteger bigInteger2 = dHPublicKey.getParams().getG();
                BigInteger bigInteger3 = dHPublicKey.getY();
                return new DHPublicKeySpec(bigInteger3, bigInteger, bigInteger2);
            }
            if (clazz.isAssignableFrom(X509EncodedKeySpec.class)) {
                if (key instanceof GnuDHPublicKey) {
                    GnuDHPublicKey gnuDHPublicKey = (GnuDHPublicKey)key;
                    byte[] byArray = gnuDHPublicKey.getEncoded(2);
                    return new X509EncodedKeySpec(byArray);
                }
                if ("X.509".equalsIgnoreCase(key.getFormat())) {
                    byte[] byArray = key.getEncoded();
                    return new X509EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (public) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (public) key specification");
        }
        if (key instanceof DHPrivateKey) {
            if (clazz.isAssignableFrom(DHPrivateKeySpec.class)) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
                BigInteger bigInteger = dHPrivateKey.getParams().getP();
                BigInteger bigInteger4 = dHPrivateKey.getParams().getG();
                BigInteger bigInteger5 = dHPrivateKey.getX();
                return new DHPrivateKeySpec(bigInteger5, bigInteger, bigInteger4);
            }
            if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                if (key instanceof GnuDHPrivateKey) {
                    GnuDHPrivateKey gnuDHPrivateKey = (GnuDHPrivateKey)key;
                    byte[] byArray = gnuDHPrivateKey.getEncoded(3);
                    return new PKCS8EncodedKeySpec(byArray);
                }
                if ("PKCS#8".equalsIgnoreCase(key.getFormat())) {
                    byte[] byArray = key.getEncoded();
                    return new PKCS8EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (private) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (private) key specification");
        }
        throw new InvalidKeySpecException("Wrong key type or unsupported key specification");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GnuDHPublicKey || key instanceof GnuDHPrivateKey) {
            return key;
        }
        if (key instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)key;
            BigInteger bigInteger = dHPublicKey.getParams().getP();
            BigInteger bigInteger2 = dHPublicKey.getParams().getG();
            BigInteger bigInteger3 = dHPublicKey.getY();
            return new GnuDHPublicKey(2, null, bigInteger, bigInteger2, bigInteger3);
        }
        if (key instanceof DHPrivateKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
            BigInteger bigInteger = dHPrivateKey.getParams().getP();
            BigInteger bigInteger4 = dHPrivateKey.getParams().getG();
            BigInteger bigInteger5 = dHPrivateKey.getX();
            return new GnuDHPrivateKey(3, null, bigInteger, bigInteger4, bigInteger5);
        }
        throw new InvalidKeyException("Wrong key type");
    }
}

