/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.Fortuna;
import java.security.SecureRandomSpi;
import java.util.Collections;

public final class FortunaImpl
extends SecureRandomSpi {
    private boolean virgin = true;
    private final Fortuna adaptee = new Fortuna();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineSetSeed(byte[] byArray) {
        Fortuna fortuna = this.adaptee;
        synchronized (fortuna) {
            if (this.virgin) {
                this.adaptee.init(Collections.singletonMap("gnu.crypto.prng.fortuna.seed", byArray));
                this.virgin = false;
            } else {
                this.adaptee.addRandomBytes(byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] byArray) {
        Fortuna fortuna = this.adaptee;
        synchronized (fortuna) {
            if (this.virgin) {
                this.engineSetSeed(this.engineGenerateSeed(32));
            }
            try {
                this.adaptee.nextBytes(byArray);
            }
            catch (LimitReachedException limitReachedException) {
                throw new Error(limitReachedException);
            }
        }
    }

    protected byte[] engineGenerateSeed(int n) {
        return SecureRandomAdapter.getSeed(n);
    }
}

