/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.CSPRNG;
import java.net.MalformedURLException;
import java.security.SecureRandomSpi;

public class CSPRNGSpi
extends SecureRandomSpi {
    private final IRandom adaptee = CSPRNG.getSystemInstance();
    private boolean virgin = true;

    protected byte[] engineGenerateSeed(int n) {
        return SecureRandomAdapter.getSeed(n);
    }

    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.virgin) {
            this.engineSetSeed(this.engineGenerateSeed(32));
        }
        try {
            this.adaptee.nextBytes(byArray, 0, byArray.length);
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException("random-number generator has been exhausted");
        }
    }

    protected void engineSetSeed(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.adaptee.addRandomBytes(byArray, 0, byArray.length);
        this.virgin = false;
    }
}

