/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.security.SecureRandomSpi;
import java.util.HashMap;

public class ARCFourRandomSpi
extends SecureRandomSpi {
    private IRandom adaptee = PRNGFactory.getInstance("arcfour");
    private boolean virgin = true;

    public byte[] engineGenerateSeed(int n) {
        return SecureRandomAdapter.getSeed(n);
    }

    public void engineNextBytes(byte[] byArray) {
        if (this.virgin) {
            this.engineSetSeed(this.engineGenerateSeed(32));
        }
        try {
            this.adaptee.nextBytes(byArray, 0, byArray.length);
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
    }

    public void engineSetSeed(byte[] byArray) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        hashMap.put("gnu.crypto.prng.arcfour.key-material", byArray);
        this.adaptee.init(hashMap);
        this.virgin = false;
    }
}

