/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import gnu.javax.crypto.kwa.IKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import gnu.javax.crypto.kwa.KeyWrappingAlgorithmFactory;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class KeyWrappingAlgorithmAdapter
extends CipherSpi {
    private static final Logger log = null;
    private static final String NO_PADDING = "nopadding";
    protected IKeyWrappingAlgorithm kwAlgorithm;
    protected int kwaBlockSize;
    protected int kwaKeySize;
    protected String supportedMode;
    protected int opmode = -1;
    byte[] iv;

    protected KeyWrappingAlgorithmAdapter(String string, int n, int n2, String string2) {
        this.kwAlgorithm = KeyWrappingAlgorithmFactory.getInstance(string);
        this.kwaBlockSize = n;
        this.kwaKeySize = n2;
        this.supportedMode = string2;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = this.kwAlgorithm.wrap(byArray, 0, byArray.length);
        return byArray2;
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key;
        byte[] byArray2;
        try {
            byArray2 = this.kwAlgorithm.unwrap(byArray, 0, byArray.length);
        }
        catch (KeyUnwrappingException keyUnwrappingException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("engineUnwrap()");
            invalidKeyException.initCause(keyUnwrappingException);
            throw invalidKeyException;
        }
        switch (n) {
            case 3: {
                key = new SecretKeySpec(byArray2, string);
                break;
            }
            case 1: 
            case 2: {
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                try {
                    if (n == 2) {
                        key = keyFactory.generatePrivate(x509EncodedKeySpec);
                        break;
                    }
                    key = keyFactory.generatePublic(x509EncodedKeySpec);
                    break;
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    InvalidKeyException invalidKeyException = new InvalidKeyException("engineUnwrap()");
                    invalidKeyException.initCause(invalidKeySpecException);
                    throw invalidKeyException;
                }
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid 'wrappedKeyType': " + n);
                InvalidKeyException invalidKeyException = new InvalidKeyException("engineUnwrap()");
                invalidKeyException.initCause(illegalArgumentException);
                throw invalidKeyException;
            }
        }
        return key;
    }

    protected int engineGetBlockSize() {
        return this.kwaBlockSize;
    }

    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    protected int engineGetOutputSize(int n) {
        switch (this.opmode) {
            case 3: {
                return this.getOutputSizeForWrap(n);
            }
            case 4: {
                return this.getOutputSizeForUnwrap(n);
            }
        }
        throw new IllegalStateException();
    }

    protected AlgorithmParameters engineGetParameters() {
        BlockCipherParameterSpec blockCipherParameterSpec = new BlockCipherParameterSpec(this.iv, this.kwaBlockSize, this.kwaKeySize);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("BlockCipherParameters");
            algorithmParameters.init(blockCipherParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.checkOpMode(n);
        byte[] byArray = this.checkAndGetKekBytes(key);
        this.initAlgorithm(n, byArray, null, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        BlockCipherParameterSpec blockCipherParameterSpec = null;
        try {
            if (algorithmParameters != null) {
                blockCipherParameterSpec = algorithmParameters.getParameterSpec(BlockCipherParameterSpec.class);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
        this.engineInit(n, key, blockCipherParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.checkOpMode(n);
        byte[] byArray = this.checkAndGetKekBytes(key);
        byte[] byArray2 = null;
        if (algorithmParameterSpec instanceof BlockCipherParameterSpec) {
            byArray2 = ((BlockCipherParameterSpec)algorithmParameterSpec).getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            byArray2 = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }
        this.initAlgorithm(n, byArray, byArray2, secureRandom);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!this.supportedMode.equalsIgnoreCase(string)) {
            throw new UnsupportedOperationException("Only " + this.supportedMode + " is supported");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!NO_PADDING.equalsIgnoreCase(string)) {
            throw new UnsupportedOperationException("Only NoPadding is supported");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        throw new UnsupportedOperationException();
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        throw new UnsupportedOperationException();
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        throw new UnsupportedOperationException();
    }

    protected int getOutputSizeForWrap(int n) {
        return this.kwaBlockSize * (n + this.kwaBlockSize - 1) / this.kwaBlockSize;
    }

    protected int getOutputSizeForUnwrap(int n) {
        return this.kwaBlockSize * (n + this.kwaBlockSize - 1) / this.kwaBlockSize;
    }

    private void checkOpMode(int n) {
        switch (n) {
            case 3: 
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported operational mode: " + n);
    }

    private byte[] checkAndGetKekBytes(Key key) throws InvalidKeyException {
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Only RAW key format is supported");
        }
        byte[] byArray = key.getEncoded();
        int n = byArray.length;
        if (n != this.kwaKeySize) {
            throw new InvalidKeyException("Invalid key material size. Expected " + this.kwaKeySize + " but found " + n);
        }
        return byArray;
    }

    private void initAlgorithm(int n, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) throws InvalidKeyException {
        this.opmode = n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.kwa.kek", byArray);
        if (byArray2 != null) {
            this.iv = (byte[])byArray2.clone();
            hashMap.put("gnu.crypto.kwa.iv", this.iv);
        } else {
            this.iv = null;
        }
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.kwa.prng", secureRandom);
        }
        this.kwAlgorithm.init(hashMap);
    }
}

