/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

class CipherAdapter
extends CipherSpi {
    protected IBlockCipher cipher;
    protected IMode mode;
    protected IPad pad;
    protected int keyLen;
    protected Map attributes;
    protected byte[] partBlock;
    protected int partLen;
    protected int blockLen;

    protected CipherAdapter(String string, int n) {
        this.cipher = CipherFactory.getInstance(string);
        this.attributes = new HashMap();
        this.blockLen = n;
        this.mode = ModeFactory.getInstance("ECB", this.cipher, n);
        this.attributes.put("gnu.crypto.cipher.block.size", n);
    }

    protected CipherAdapter(String string) {
        this.cipher = CipherFactory.getInstance(string);
        this.blockLen = this.cipher.defaultBlockSize();
        this.attributes = new HashMap();
        this.mode = ModeFactory.getInstance("ECB", this.cipher, this.blockLen);
        this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string.length() >= 3 && string.substring(0, 3).equalsIgnoreCase("CFB")) {
            if (string.length() > 3) {
                try {
                    int n = Integer.parseInt(string.substring(3));
                    this.attributes.put("gnu.crypto.mode.block.size", n / 8);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException(string);
                }
                string = "CFB";
            }
        } else {
            this.attributes.remove("gnu.crypto.mode.block.size");
        }
        this.mode = ModeFactory.getInstance(string, this.cipher, this.blockLen);
        if (this.mode == null) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase("NoPadding")) {
            this.pad = null;
            return;
        }
        this.pad = PadFactory.getInstance(string);
        if (this.pad == null) {
            throw new NoSuchPaddingException(string);
        }
    }

    protected int engineGetBlockSize() {
        if (this.cipher != null) {
            return this.blockLen;
        }
        return 0;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = this.mode.currentBlockSize();
        return (n + this.partLen) / n2 * n2;
    }

    protected byte[] engineGetIV() {
        byte[] byArray = (byte[])this.attributes.get("gnu.crypto.mode.iv");
        if (byArray == null) {
            return null;
        }
        return (byte[])byArray.clone();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters;
        byte[] byArray = (byte[])this.attributes.get("gnu.crypto.mode.iv");
        int n = this.cipher.currentBlockSize();
        BlockCipherParameterSpec blockCipherParameterSpec = new BlockCipherParameterSpec(byArray, n, this.keyLen);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("BlockCipherParameters");
            algorithmParameters.init(blockCipherParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    private void engineInitHandler(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        Object object;
        switch (n) {
            case 1: {
                this.attributes.put("gnu.crypto.mode.state", 1);
                break;
            }
            case 2: {
                this.attributes.put("gnu.crypto.mode.state", 2);
            }
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("bad key format " + key.getFormat());
        }
        byte[] byArray = key.getEncoded();
        int n2 = byArray.length;
        if (this.keyLen == 0) {
            object = this.cipher.keySizes();
            while (object.hasNext()) {
                int n3 = (Integer)object.next();
                if (n3 == n2) {
                    this.keyLen = n3;
                    break;
                }
                if (n3 >= n2) break;
                this.keyLen = n3;
            }
        }
        if (this.keyLen == 0) {
            this.keyLen = n2;
        }
        if (this.keyLen < n2) {
            object = byArray;
            byArray = new byte[this.keyLen];
            System.arraycopy(object, 0, byArray, 0, this.keyLen);
        }
        this.attributes.put("gnu.crypto.cipher.key.material", byArray);
        this.reset();
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            if (!this.mode.name().toLowerCase().startsWith("ecb(")) {
                switch (n) {
                    case 1: 
                    case 3: {
                        byte[] byArray = new byte[this.blockLen];
                        secureRandom.nextBytes(byArray);
                        this.attributes.put("gnu.crypto.mode.iv", byArray);
                        break;
                    }
                    default: {
                        throw new InvalidAlgorithmParameterException("Required algorithm parameters are missing for mode: " + this.mode.name());
                    }
                }
            }
            this.blockLen = this.cipher.defaultBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
            this.keyLen = 0;
        } else if (algorithmParameterSpec instanceof BlockCipherParameterSpec) {
            BlockCipherParameterSpec blockCipherParameterSpec = (BlockCipherParameterSpec)algorithmParameterSpec;
            this.blockLen = blockCipherParameterSpec.getBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
            this.attributes.put("gnu.crypto.mode.iv", blockCipherParameterSpec.getIV());
            this.keyLen = blockCipherParameterSpec.getKeySize();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (((IvParameterSpec)algorithmParameterSpec).getIV().length != this.cipher.defaultBlockSize()) {
                throw new InvalidAlgorithmParameterException();
            }
            this.attributes.put("gnu.crypto.mode.iv", ((IvParameterSpec)algorithmParameterSpec).getIV());
            this.blockLen = this.cipher.defaultBlockSize();
            this.attributes.put("gnu.crypto.cipher.block.size", this.blockLen);
            this.keyLen = 0;
        }
        this.engineInitHandler(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        BlockCipherParameterSpec blockCipherParameterSpec = null;
        try {
            if (algorithmParameters != null) {
                blockCipherParameterSpec = algorithmParameters.getParameterSpec(BlockCipherParameterSpec.class);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
        this.engineInit(n, key, blockCipherParameterSpec, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = this.mode.currentBlockSize();
        int n4 = (this.partLen + n2) / n3;
        if (this.pad != null && (Integer)this.attributes.get("gnu.crypto.mode.state") == 2 && (this.partLen + n2) % n3 == 0) {
            --n4;
        }
        byte[] byArray2 = new byte[n4 * n3];
        try {
            this.engineUpdate(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace(System.err);
        }
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        byte[] byArray3;
        int n4;
        if (n2 == 0) {
            return 0;
        }
        int n5 = this.mode.currentBlockSize();
        int n6 = (this.partLen + n2) / n5;
        if (this.pad != null && (Integer)this.attributes.get("gnu.crypto.mode.state") == 2 && (this.partLen + n2) % n5 == 0) {
            --n6;
        }
        if ((n4 = n6 * n5) > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        if (n6 == 0) {
            System.arraycopy(byArray, n, this.partBlock, this.partLen, n2);
            this.partLen += n2;
            return 0;
        }
        if (this.partLen == 0) {
            byArray3 = byArray;
        } else {
            byArray3 = new byte[this.partLen + n2];
            System.arraycopy(this.partBlock, 0, byArray3, 0, this.partLen);
            if (byArray != null && n2 > 0) {
                System.arraycopy(byArray, n, byArray3, this.partLen, n2);
            }
            n = 0;
        }
        for (int i = 0; i < n6; ++i) {
            this.mode.update(byArray3, n, byArray2, n3);
            n += n5;
            n3 += n5;
        }
        this.partLen += n2 - n4;
        if (this.partLen > 0) {
            System.arraycopy(byArray3, n, this.partBlock, 0, this.partLen);
        }
        return n4;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        block11: {
            byte[] byArray3;
            block10: {
                byArray3 = this.engineUpdate(byArray, n, n2);
                if (this.pad == null) break block10;
                switch ((Integer)this.attributes.get("gnu.crypto.mode.state")) {
                    case 1: {
                        byte[] byArray4 = this.pad.pad(this.partBlock, 0, this.partLen);
                        byte[] byArray5 = this.engineUpdate(byArray4, 0, byArray4.length);
                        byArray2 = new byte[byArray3.length + byArray5.length];
                        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                        System.arraycopy(byArray5, 0, byArray2, byArray3.length, byArray5.length);
                        break block11;
                    }
                    case 2: {
                        int n3;
                        byte[] byArray6 = new byte[byArray3.length + this.partLen];
                        try {
                            if (this.partLen != this.mode.currentBlockSize()) {
                                throw new WrongPaddingException();
                            }
                            System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
                            this.mode.update(this.partBlock, 0, byArray6, byArray3.length);
                            n3 = this.pad.unpad(byArray6, 0, byArray6.length);
                        }
                        catch (WrongPaddingException wrongPaddingException) {
                            throw new BadPaddingException(wrongPaddingException.getMessage());
                        }
                        byArray2 = new byte[byArray6.length - n3];
                        System.arraycopy(byArray6, 0, byArray2, 0, byArray2.length);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (this.partLen > 0) {
                throw new IllegalBlockSizeException(this.partLen + " trailing bytes");
            }
            byArray2 = byArray3;
        }
        try {
            this.reset();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error(invalidKeyException);
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray2.length + n3 < byArray3.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    private void reset() throws InvalidKeyException {
        this.mode.reset();
        this.mode.init(this.attributes);
        if (this.pad != null) {
            this.pad.reset();
            this.pad.init(this.blockLen);
        }
        this.partBlock = new byte[this.blockLen];
        this.partLen = 0;
    }
}

