/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.Anubis;
import gnu.javax.crypto.cipher.BaseCipher;
import gnu.javax.crypto.cipher.Blowfish;
import gnu.javax.crypto.cipher.Cast5;
import gnu.javax.crypto.cipher.DES;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.cipher.Khazad;
import gnu.javax.crypto.cipher.NullCipher;
import gnu.javax.crypto.cipher.Rijndael;
import gnu.javax.crypto.cipher.Serpent;
import gnu.javax.crypto.cipher.Square;
import gnu.javax.crypto.cipher.TripleDES;
import gnu.javax.crypto.cipher.Twofish;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CipherFactory
implements Registry {
    private CipherFactory() {
    }

    public static final IBlockCipher getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseCipher baseCipher = null;
        if (string.equalsIgnoreCase("anubis")) {
            baseCipher = new Anubis();
        } else if (string.equalsIgnoreCase("blowfish")) {
            baseCipher = new Blowfish();
        } else if (string.equalsIgnoreCase("des")) {
            baseCipher = new DES();
        } else if (string.equalsIgnoreCase("khazad")) {
            baseCipher = new Khazad();
        } else if (string.equalsIgnoreCase("rijndael") || string.equalsIgnoreCase("aes")) {
            baseCipher = new Rijndael();
        } else if (string.equalsIgnoreCase("serpent")) {
            baseCipher = new Serpent();
        } else if (string.equalsIgnoreCase("square")) {
            baseCipher = new Square();
        } else if (string.equalsIgnoreCase("tripledes") || string.equalsIgnoreCase("desede")) {
            baseCipher = new TripleDES();
        } else if (string.equalsIgnoreCase("twofish")) {
            baseCipher = new Twofish();
        } else if (string.equalsIgnoreCase("cast5") || string.equalsIgnoreCase("cast128") || string.equalsIgnoreCase("cast-128")) {
            baseCipher = new Cast5();
        } else if (string.equalsIgnoreCase("null")) {
            baseCipher = new NullCipher();
        }
        if (baseCipher != null && !baseCipher.selfTest()) {
            throw new InternalError(baseCipher.name());
        }
        return baseCipher;
    }

    public static final Set getNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("anubis");
        hashSet.add("blowfish");
        hashSet.add("des");
        hashSet.add("khazad");
        hashSet.add("rijndael");
        hashSet.add("serpent");
        hashSet.add("square");
        hashSet.add("tripledes");
        hashSet.add("twofish");
        hashSet.add("cast5");
        hashSet.add("null");
        return Collections.unmodifiableSet(hashSet);
    }
}

