/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.Map;

class PaddingTransformer
extends Transformer {
    private IPad delegate;
    private int outputBlockSize = 1;

    PaddingTransformer(IPad iPad) {
        this.delegate = iPad;
    }

    void initDelegate(Map map) throws TransformerException {
        if (this.tail == null) {
            IllegalStateException illegalStateException = new IllegalStateException("Padding transformer missing its tail!");
            throw new TransformerException("initDelegate()", illegalStateException);
        }
        this.outputBlockSize = this.tail.currentBlockSize();
        this.delegate.init(this.outputBlockSize);
    }

    int delegateBlockSize() {
        return this.outputBlockSize;
    }

    void resetDelegate() {
        this.delegate.reset();
        this.outputBlockSize = 1;
    }

    byte[] updateDelegate(byte[] byArray, int n, int n2) throws TransformerException {
        byte[] byArray2;
        this.inBuffer.write(byArray, n, n2);
        byte[] byArray3 = this.inBuffer.toByteArray();
        this.inBuffer.reset();
        if (this.wired == Direction.FORWARD) {
            if (byArray3.length < this.outputBlockSize) {
                this.inBuffer.write(byArray3, 0, byArray3.length);
                byArray2 = new byte[]{};
            } else {
                int n3 = this.outputBlockSize * (byArray3.length / this.outputBlockSize);
                this.inBuffer.write(byArray3, n3, byArray3.length - n3);
                byArray2 = new byte[n3];
                System.arraycopy(byArray3, 0, byArray2, 0, n3);
            }
        } else if (byArray3.length < this.outputBlockSize) {
            this.inBuffer.write(byArray3, 0, byArray3.length);
            byArray2 = new byte[]{};
        } else {
            byArray2 = new byte[byArray3.length - this.outputBlockSize];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
            this.inBuffer.write(byArray3, byArray2.length, this.outputBlockSize);
        }
        return byArray2;
    }

    byte[] lastUpdateDelegate() throws TransformerException {
        byte[] byArray;
        if (this.wired == Direction.FORWARD) {
            byArray = this.inBuffer.toByteArray();
            byte[] byArray2 = this.delegate.pad(byArray, 0, byArray.length);
            this.inBuffer.write(byArray2, 0, byArray2.length);
        } else {
            byte[] byArray3 = this.inBuffer.toByteArray();
            this.inBuffer.reset();
            try {
                int n = byArray3.length;
            }
            catch (WrongPaddingException wrongPaddingException) {
                throw new TransformerException("lastUpdateDelegate()", wrongPaddingException);
            }
            this.inBuffer.write(byArray3, 0, n -= this.delegate.unpad(byArray3, 0, byArray3.length));
        }
        byArray = this.inBuffer.toByteArray();
        this.inBuffer.reset();
        return byArray;
    }
}

