/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.sig.rsa.EME_PKCS1_V1_5;
import gnu.java.security.util.ByteArray;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class RSACipherImpl
extends CipherSpi {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private static final byte[] EMPTY = new byte[0];
    private int opmode = -1;
    private RSAPrivateKey decipherKey = null;
    private RSAPublicKey blindingKey = null;
    private RSAPublicKey encipherKey = null;
    private SecureRandom random = null;
    private byte[] dataBuffer = null;
    private int pos = 0;

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("only one mode available");
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("only one padding available");
    }

    protected int engineGetBlockSize() {
        return 1;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = 0;
        if (this.decipherKey != null) {
            n2 = (this.decipherKey.getModulus().bitLength() + 7) / 8;
        } else if (this.encipherKey != null) {
            n2 = (this.encipherKey.getModulus().bitLength() + 7) / 8;
        } else {
            throw new IllegalStateException("not initialized");
        }
        if (n > n2) {
            throw new IllegalArgumentException("not configured to encode " + n + "bytes; at most " + n2);
        }
        return n2;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAKey)) {
            throw new InvalidKeyException("not an RSA key");
        }
        return ((RSAKey)((Object)key)).getModulus().bitLength();
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        int n2 = 0;
        if (n == 1) {
            if (!(key instanceof RSAPublicKey)) {
                throw new InvalidKeyException("expecting a RSAPublicKey");
            }
            this.encipherKey = (RSAPublicKey)key;
            this.decipherKey = null;
            this.blindingKey = null;
            n2 = (this.encipherKey.getModulus().bitLength() + 7) / 8;
        } else {
            if (n != 2) throw new IllegalArgumentException("only encryption and decryption supported");
            if (key instanceof RSAPrivateKey) {
                this.decipherKey = (RSAPrivateKey)key;
                this.encipherKey = null;
                this.blindingKey = null;
                n2 = (this.decipherKey.getModulus().bitLength() + 7) / 8;
            } else {
                if (!(key instanceof RSAPublicKey)) throw new InvalidKeyException("expecting either an RSAPrivateKey or an RSAPublicKey (for blinding)");
                if (this.decipherKey == null) {
                    throw new IllegalStateException("must configure decryption key first");
                }
                if (!this.decipherKey.getModulus().equals(((RSAPublicKey)key).getModulus())) {
                    throw new InvalidKeyException("blinding key is not compatible");
                }
                this.blindingKey = (RSAPublicKey)key;
                return;
            }
        }
        this.random = secureRandom;
        this.opmode = n;
        this.pos = 0;
        this.dataBuffer = new byte[n2];
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n, key, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("not initialized");
        }
        System.arraycopy(byArray, n, this.dataBuffer, this.pos, n2);
        this.pos += n2;
        return EMPTY;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.engineUpdate(byArray, n, n2);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        this.engineUpdate(byArray, n, n2);
        if (this.opmode == 2) {
            BigInteger bigInteger = new BigInteger(1, this.dataBuffer);
            byte[] byArray2 = this.rsaDecrypt(bigInteger);
            logger.log((Level)Component.CRYPTO, "RSA: decryption produced\n{0}", new ByteArray(byArray2));
            EME_PKCS1_V1_5 eME_PKCS1_V1_5 = EME_PKCS1_V1_5.getInstance(this.decipherKey);
            byte[] byArray3 = eME_PKCS1_V1_5.decode(byArray2);
            return byArray3;
        }
        n = this.dataBuffer.length - this.pos;
        if (n < 3) {
            throw new IllegalBlockSizeException("input is too large to encrypt");
        }
        EME_PKCS1_V1_5 eME_PKCS1_V1_5 = EME_PKCS1_V1_5.getInstance(this.encipherKey);
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] byArray4 = new byte[this.pos];
        System.arraycopy(this.dataBuffer, 0, byArray4, 0, this.pos);
        byte[] byArray5 = eME_PKCS1_V1_5.encode(byArray4, this.random);
        logger.log((Level)Component.CRYPTO, "RSA: produced padded plaintext\n{0}", new ByteArray(byArray5));
        BigInteger bigInteger = new BigInteger(1, byArray5);
        BigInteger bigInteger2 = bigInteger.modPow(this.encipherKey.getPublicExponent(), this.encipherKey.getModulus());
        byte[] byArray6 = bigInteger2.toByteArray();
        if (byArray6[0] == 0) {
            byte[] byArray7 = new byte[byArray6.length - 1];
            System.arraycopy(byArray6, 1, byArray7, 0, byArray7.length);
            byArray6 = byArray7;
        }
        this.pos = 0;
        return byArray6;
    }

    protected int engineDoFinal(byte[] byArray, int n) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = this.engineDoFinal(EMPTY, 0, 0);
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException("need " + byArray2.length + ", have " + (byArray.length - n));
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray2.length - n3 < byArray3.length) {
            throw new ShortBufferException("need " + byArray3.length + ", have " + (byArray2.length - n3));
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    private byte[] rsaDecrypt(BigInteger bigInteger) {
        byte[] byArray;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        BigInteger bigInteger2 = this.decipherKey.getModulus();
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        if (this.blindingKey != null) {
            bigInteger4 = this.blindingKey.getPublicExponent();
        }
        if (bigInteger4 != null && this.decipherKey instanceof RSAPrivateCrtKey) {
            bigInteger4 = ((RSAPrivateCrtKey)this.decipherKey).getPublicExponent();
        }
        if (bigInteger4 != null) {
            bigInteger3 = new BigInteger(bigInteger2.bitLength() - 1, this.random);
            bigInteger = bigInteger3.modPow(bigInteger4, bigInteger2).multiply(bigInteger).mod(bigInteger2);
        }
        BigInteger bigInteger5 = bigInteger.modPow(this.decipherKey.getPrivateExponent(), bigInteger2);
        if (bigInteger4 != null) {
            bigInteger5 = bigInteger5.multiply(bigInteger3.modInverse(bigInteger2)).mod(bigInteger2);
        }
        if ((byArray = bigInteger5.toByteArray())[0] != 0) {
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

