/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenChar;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RETokenOneOf
extends REToken {
    private final List<REToken> options;
    private boolean negative;
    private boolean matchesOneChar;
    private final List<Object> addition;

    RETokenOneOf(int n, String string, boolean bl, boolean bl2) {
        super(n);
        this.options = new ArrayList<REToken>();
        this.negative = bl;
        for (int i = 0; i < string.length(); ++i) {
            this.options.add(new RETokenChar(n, string.charAt(i), bl2));
        }
        this.matchesOneChar = true;
        this.addition = null;
    }

    RETokenOneOf(int n, List<REToken> list2, boolean bl) {
        this(n, list2, null, bl);
    }

    RETokenOneOf(int n, List<REToken> list2, List<Object> list3, boolean bl) {
        super(n);
        this.options = list2;
        this.addition = list3;
        this.negative = bl;
        this.matchesOneChar = bl || list3 != null;
    }

    @Override
    int getMinimumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int n = Integer.MAX_VALUE;
        for (REToken rEToken : this.options) {
            int n2 = rEToken.getMinimumLength();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    int getMaximumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int n = 0;
        for (REToken rEToken : this.options) {
            int n2 = rEToken.getMaximumLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        this.setHitEnd(charIndexed, rEMatch);
        if (this.matchesOneChar) {
            return this.matchOneChar(charIndexed, rEMatch);
        }
        return this.matchOneRE(charIndexed, rEMatch);
    }

    boolean matchOneChar(CharIndexed charIndexed, REMatch rEMatch) {
        boolean bl;
        boolean bl2;
        REMatch rEMatch2;
        if (this.addition == null) {
            rEMatch2 = rEMatch;
            bl2 = false;
        } else {
            rEMatch2 = (REMatch)rEMatch.clone();
            bl2 = true;
        }
        boolean bl3 = bl = this.negative ? this.matchN(charIndexed, rEMatch2, bl2) : this.matchP(charIndexed, rEMatch2, bl2);
        if (this.addition == null) {
            return bl;
        }
        ArrayDeque<Boolean> arrayDeque = new ArrayDeque<Boolean>();
        arrayDeque.push(new Boolean(bl));
        for (Object object : this.addition) {
            if (object instanceof REToken) {
                bl = ((REToken)object).match(charIndexed, (REMatch)rEMatch.clone());
                arrayDeque.push(new Boolean(bl));
                continue;
            }
            if (object instanceof Boolean) {
                arrayDeque.push((Boolean)object);
                continue;
            }
            if (object.equals("|")) {
                bl = (Boolean)arrayDeque.pop();
                bl = (Boolean)arrayDeque.pop() != false || bl;
                arrayDeque.push(new Boolean(bl));
                continue;
            }
            if (object.equals("&")) {
                bl = (Boolean)arrayDeque.pop();
                bl = (Boolean)arrayDeque.pop() != false && bl;
                arrayDeque.push(new Boolean(bl));
                continue;
            }
            throw new RuntimeException("Invalid object found");
        }
        if (((Boolean)arrayDeque.pop()).booleanValue()) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    private boolean matchN(CharIndexed charIndexed, REMatch rEMatch, boolean bl) {
        if (charIndexed.charAt(rEMatch.index) == '\uffff') {
            return false;
        }
        for (REToken rEToken : this.options) {
            REMatch rEMatch2;
            if (!rEToken.match(charIndexed, rEMatch2 = (REMatch)rEMatch.clone())) continue;
            return false;
        }
        if (bl) {
            return true;
        }
        ++rEMatch.index;
        return this.next(charIndexed, rEMatch);
    }

    private boolean matchP(CharIndexed charIndexed, REMatch rEMatch, boolean bl) {
        for (REToken rEToken : this.options) {
            REMatch rEMatch2;
            if (!rEToken.match(charIndexed, rEMatch2 = (REMatch)rEMatch.clone())) continue;
            if (bl) {
                return true;
            }
            if (!this.next(charIndexed, rEMatch2)) continue;
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        return false;
    }

    private boolean matchOneRE(CharIndexed charIndexed, REMatch rEMatch) {
        REMatch rEMatch2 = this.findMatch(charIndexed, rEMatch);
        if (rEMatch2 != null) {
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        return false;
    }

    @Override
    REMatch findMatch(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.matchesOneChar) {
            return super.findMatch(charIndexed, rEMatch);
        }
        return this.findMatch(charIndexed, rEMatch, 0);
    }

    @Override
    REMatch backtrack(CharIndexed charIndexed, REMatch rEMatch, Object object) {
        return this.findMatch(charIndexed, rEMatch, (Integer)object);
    }

    private REMatch findMatch(CharIndexed charIndexed, REMatch rEMatch, int n) {
        for (int i = n; i < this.options.size(); ++i) {
            REToken rEToken = this.options.get(i);
            rEToken = (REToken)rEToken.clone();
            rEToken.chain(this.getNext());
            REMatch rEMatch2 = (REMatch)rEMatch.clone();
            if (rEMatch2.backtrackStack == null) {
                rEMatch2.backtrackStack = new BacktrackStack();
            }
            boolean bl = false;
            if (i + 1 < this.options.size()) {
                rEMatch2.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, i + 1));
                bl = true;
            }
            if (rEToken.match(charIndexed, rEMatch2)) {
                return rEMatch2;
            }
            if (!bl) continue;
            rEMatch2.backtrackStack.pop();
        }
        return null;
    }

    @Override
    boolean returnsFixedLengthMatches() {
        return this.matchesOneChar;
    }

    @Override
    int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        int n2;
        if (!this.matchesOneChar) {
            return super.findFixedLengthMatches(charIndexed, rEMatch, n);
        }
        REMatch rEMatch2 = (REMatch)rEMatch.clone();
        REToken rEToken = (REToken)this.clone();
        rEToken.chain(null);
        for (n2 = 0; n2 < n && (rEMatch2 = rEToken.findMatch(charIndexed, rEMatch2)) != null; ++n2) {
        }
        return n2;
    }

    @Override
    void dump(CPStringBuilder cPStringBuilder) {
        cPStringBuilder.append(this.negative ? "[^" : "(?:");
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.negative && i > 0) {
                cPStringBuilder.append('|');
            }
            this.options.get(i).dumpAll(cPStringBuilder);
        }
        cPStringBuilder.append(this.negative ? (char)']' : ')');
    }
}

