/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REException;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenPOSIX;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class RETokenNamedProperty
extends REToken {
    String name;
    boolean insens;
    boolean negate;
    Handler handler;
    static final byte[] LETTER = new byte[]{2, 1, 3, 4, 5};
    static final byte[] MARK = new byte[]{6, 8, 7};
    static final byte[] SEPARATOR = new byte[]{12, 13, 14};
    static final byte[] SYMBOL = new byte[]{25, 26, 27, 28};
    static final byte[] NUMBER = new byte[]{9, 10, 11};
    static final byte[] PUNCTUATION = new byte[]{20, 21, 22, 23, 24, 29, 30};
    static final byte[] OTHER = new byte[]{15, 16, 18, 19, 0};

    RETokenNamedProperty(int n, String string, boolean bl, boolean bl2) throws REException {
        super(n);
        this.name = string;
        this.insens = bl;
        this.negate = bl2;
        this.handler = this.getHandler(string);
    }

    int getMinimumLength() {
        return 1;
    }

    int getMaximumLength() {
        return 1;
    }

    REMatch matchThis(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        boolean bl = this.matchOneChar(c);
        if (bl) {
            ++rEMatch.index;
            return rEMatch;
        }
        return null;
    }

    private boolean matchOneChar(char c) {
        if (c == '\uffff') {
            return false;
        }
        boolean bl = this.handler.includes(c);
        if (this.insens) {
            boolean bl2 = bl = bl || this.handler.includes(RETokenNamedProperty.toUpperCase(c, this.unicodeAware)) || this.handler.includes(RETokenNamedProperty.toLowerCase(c, this.unicodeAware));
        }
        if (this.negate) {
            bl = !bl;
        }
        return bl;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        char c;
        int n2;
        int n3 = rEMatch.index;
        for (n2 = 0; n2 < n && this.matchOneChar(c = charIndexed.charAt(n3++)); ++n2) {
        }
        return n2;
    }

    void dump(CPStringBuilder cPStringBuilder) {
        cPStringBuilder.append("\\").append(this.negate ? "P" : "p").append("{" + this.name + "}");
    }

    private Handler getHandler(String string) throws REException {
        if (string.equals("Lower") || string.equals("Upper") || string.equals("Alpha") || string.equals("Digit") || string.equals("Alnum") || string.equals("Punct") || string.equals("Graph") || string.equals("Print") || string.equals("Blank") || string.equals("Cntrl") || string.equals("XDigit") || string.equals("Space")) {
            return new POSIXHandler(string);
        }
        if (string.startsWith("In")) {
            try {
                string = string.substring(2);
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.forName(string);
                return new UnicodeBlockHandler(unicodeBlock);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new REException("Invalid Unicode block name: " + string, 10, 0);
            }
        }
        if (string.startsWith("Is")) {
            string = string.substring(2);
        }
        if (string.equals("L")) {
            return new UnicodeCategoriesHandler(LETTER);
        }
        if (string.equals("M")) {
            return new UnicodeCategoriesHandler(MARK);
        }
        if (string.equals("Z")) {
            return new UnicodeCategoriesHandler(SEPARATOR);
        }
        if (string.equals("S")) {
            return new UnicodeCategoriesHandler(SYMBOL);
        }
        if (string.equals("N")) {
            return new UnicodeCategoriesHandler(NUMBER);
        }
        if (string.equals("P")) {
            return new UnicodeCategoriesHandler(PUNCTUATION);
        }
        if (string.equals("C")) {
            return new UnicodeCategoriesHandler(OTHER);
        }
        if (string.equals("Mc")) {
            return new UnicodeCategoryHandler(8);
        }
        if (string.equals("Pc")) {
            return new UnicodeCategoryHandler(23);
        }
        if (string.equals("Cc")) {
            return new UnicodeCategoryHandler(15);
        }
        if (string.equals("Sc")) {
            return new UnicodeCategoryHandler(26);
        }
        if (string.equals("Pd")) {
            return new UnicodeCategoryHandler(20);
        }
        if (string.equals("Nd")) {
            return new UnicodeCategoryHandler(9);
        }
        if (string.equals("Me")) {
            return new UnicodeCategoryHandler(7);
        }
        if (string.equals("Pe")) {
            return new UnicodeCategoryHandler(22);
        }
        if (string.equals("Pf")) {
            return new UnicodeCategoryHandler(30);
        }
        if (string.equals("Cf")) {
            return new UnicodeCategoryHandler(16);
        }
        if (string.equals("Pi")) {
            return new UnicodeCategoryHandler(29);
        }
        if (string.equals("Nl")) {
            return new UnicodeCategoryHandler(10);
        }
        if (string.equals("Zl")) {
            return new UnicodeCategoryHandler(13);
        }
        if (string.equals("Ll")) {
            return new UnicodeCategoryHandler(2);
        }
        if (string.equals("Sm")) {
            return new UnicodeCategoryHandler(25);
        }
        if (string.equals("Lm")) {
            return new UnicodeCategoryHandler(4);
        }
        if (string.equals("Sk")) {
            return new UnicodeCategoryHandler(27);
        }
        if (string.equals("Mn")) {
            return new UnicodeCategoryHandler(6);
        }
        if (string.equals("Lo")) {
            return new UnicodeCategoryHandler(5);
        }
        if (string.equals("No")) {
            return new UnicodeCategoryHandler(11);
        }
        if (string.equals("Po")) {
            return new UnicodeCategoryHandler(24);
        }
        if (string.equals("So")) {
            return new UnicodeCategoryHandler(28);
        }
        if (string.equals("Zp")) {
            return new UnicodeCategoryHandler(14);
        }
        if (string.equals("Co")) {
            return new UnicodeCategoryHandler(18);
        }
        if (string.equals("Zs")) {
            return new UnicodeCategoryHandler(12);
        }
        if (string.equals("Ps")) {
            return new UnicodeCategoryHandler(21);
        }
        if (string.equals("Cs")) {
            return new UnicodeCategoryHandler(19);
        }
        if (string.equals("Lt")) {
            return new UnicodeCategoryHandler(3);
        }
        if (string.equals("Cn")) {
            return new UnicodeCategoryHandler(0);
        }
        if (string.equals("Lu")) {
            return new UnicodeCategoryHandler(1);
        }
        if (string.equals("all")) {
            return new Handler(){

                public boolean includes(char c) {
                    return true;
                }
            };
        }
        if (string.startsWith("java")) {
            try {
                Method method = Character.class.getMethod("is" + string.substring(4), Character.TYPE);
                return new JavaCategoryHandler(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new REException("Unsupported Java handler: " + string, noSuchMethodException, 10, 0);
            }
        }
        throw new REException("unsupported name " + string, 10, 0);
    }

    private static class JavaCategoryHandler
    extends Handler {
        private Method method;

        public JavaCategoryHandler(Method method) {
            this.method = method;
        }

        public boolean includes(char c) {
            try {
                return (Boolean)this.method.invoke(null, Character.valueOf(c));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError("Unable to access method " + this.method);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new InternalError("Error invoking " + this.method);
            }
        }
    }

    private static class UnicodeBlockHandler
    extends Handler {
        private Character.UnicodeBlock block;

        public UnicodeBlockHandler(Character.UnicodeBlock unicodeBlock) {
            this.block = unicodeBlock;
        }

        public boolean includes(char c) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
            return unicodeBlock != null && unicodeBlock.equals(this.block);
        }
    }

    private static class UnicodeCategoriesHandler
    extends Handler {
        private byte[] categories;

        public UnicodeCategoriesHandler(byte[] byArray) {
            this.categories = byArray;
        }

        public boolean includes(char c) {
            int n = Character.getType(c);
            for (int i = 0; i < this.categories.length; ++i) {
                if (n != this.categories[i]) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnicodeCategoryHandler
    extends Handler {
        private int category;

        public UnicodeCategoryHandler(byte by) {
            this.category = by;
        }

        public boolean includes(char c) {
            return Character.getType(c) == this.category;
        }
    }

    private static class POSIXHandler
    extends Handler {
        private RETokenPOSIX retoken;

        public POSIXHandler(String string) {
            int n = RETokenPOSIX.intValue(string.toLowerCase());
            if (n == -1) {
                throw new RuntimeException("Unknown posix ID: " + string);
            }
            this.retoken = new RETokenPOSIX(0, n, false, false);
        }

        public boolean includes(char c) {
            return this.retoken.matchOneChar(c);
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        public abstract boolean includes(char var1);
    }
}

