/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenEnd
extends REToken {
    private String newline;
    private boolean check_java_line_terminators;
    private boolean fake = false;

    RETokenEnd(int n, String string) {
        super(n);
        this.newline = string;
        this.check_java_line_terminators = false;
    }

    RETokenEnd(int n, String string, boolean bl) {
        super(n);
        this.newline = string;
        this.check_java_line_terminators = bl;
    }

    void setFake(boolean bl) {
        this.fake = bl;
    }

    int getMaximumLength() {
        return 0;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        if (!this.fake) {
            return super.match(charIndexed, rEMatch);
        }
        return super.matchFake(charIndexed, rEMatch);
    }

    REMatch matchThis(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        if (c == '\uffff') {
            return (rEMatch.eflags & 0x20) > 0 ? null : rEMatch;
        }
        if (this.check_java_line_terminators) {
            if (c == '\n') {
                char c2 = charIndexed.charAt(rEMatch.index - 1);
                if (c2 == '\r') {
                    return null;
                }
                return rEMatch;
            }
            if (c == '\r') {
                return rEMatch;
            }
            if (c == '\u0085') {
                return rEMatch;
            }
            if (c == '\u2028') {
                return rEMatch;
            }
            if (c == '\u2029') {
                return rEMatch;
            }
            return null;
        }
        if (this.newline != null) {
            int n = 0;
            do {
                char c3;
                if (c != (c3 = this.newline.charAt(n))) {
                    return null;
                }
                c = charIndexed.charAt(rEMatch.index + ++n);
            } while (n < this.newline.length());
            return rEMatch;
        }
        return null;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        REMatch rEMatch2 = (REMatch)rEMatch.clone();
        REToken rEToken = (REToken)this.clone();
        rEToken.chain(null);
        if (rEToken.match(charIndexed, rEMatch2)) {
            return n;
        }
        return 0;
    }

    void dump(CPStringBuilder cPStringBuilder) {
        cPStringBuilder.append('$');
    }
}

