/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import java.io.Serializable;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    private CharIndexed matchedCharIndexed;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] start1;
    int[] end;
    boolean empty;
    BacktrackStack backtrackStack;

    public Object clone() {
        try {
            REMatch rEMatch = (REMatch)super.clone();
            rEMatch.start = (int[])this.start.clone();
            rEMatch.start1 = (int[])this.start1.clone();
            rEMatch.end = (int[])this.end.clone();
            return rEMatch;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    void assignFrom(REMatch rEMatch) {
        this.start = rEMatch.start;
        this.start1 = rEMatch.start1;
        this.end = rEMatch.end;
        this.index = rEMatch.index;
        this.backtrackStack = rEMatch.backtrackStack;
    }

    REMatch(int n, int n2, int n3) {
        this.start = new int[n + 1];
        this.start1 = new int[n + 1];
        this.end = new int[n + 1];
        this.anchor = n2;
        this.eflags = n3;
        this.clear(n2);
    }

    void finish(CharIndexed charIndexed) {
        int n;
        this.start[0] = 0;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (n = 0; n < this.end[0]; ++n) {
            cPStringBuilder.append(charIndexed.charAt(n));
        }
        this.matchedText = cPStringBuilder.toString();
        this.matchedCharIndexed = charIndexed;
        for (n = 0; n < this.start.length; ++n) {
            if (!(this.start[n] == -1 ^ this.end[n] == -1)) continue;
            this.start[n] = -1;
            this.end[n] = -1;
        }
        this.backtrackStack = null;
    }

    void clear(int n) {
        this.offset = n;
        this.index = 0;
        for (int i = 0; i < this.start.length; ++i) {
            this.end[i] = -1;
            this.start1[i] = -1;
            this.start[i] = -1;
        }
        this.backtrackStack = null;
    }

    public String toString() {
        return this.matchedText;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int n) {
        if (n >= this.start.length || n < 0) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        if (this.start[n] == -1) {
            return null;
        }
        if (this.start[n] >= 0 && this.end[n] <= this.matchedText.length()) {
            return this.matchedText.substring(this.start[n], this.end[n]);
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n2 = this.start[n];
        int n3 = this.end[n];
        if (n2 < 0) {
            ++n2;
        }
        if (n3 < 0) {
            ++n3;
        }
        for (int i = this.start[0] + n2; i < this.start[0] + n3; ++i) {
            cPStringBuilder.append(this.matchedCharIndexed.charAt(i));
        }
        return cPStringBuilder.toString();
    }

    public int getSubStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public int getStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public int getSubEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public int getEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public String substituteInto(String string) {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (n = 0; n < string.length() - 1; ++n) {
            if (string.charAt(n) == '$' && Character.isDigit(string.charAt(n + 1))) {
                int n2;
                int n3;
                int n4 = Character.digit(string.charAt(++n), 10);
                for (n3 = n + 1; n3 < string.length() && Character.isDigit(string.charAt(n3)) && (n2 = n4 * 10 + Character.digit(string.charAt(n3), 10)) < this.start.length; ++n3) {
                    n4 = n2;
                }
                n = n3 - 1;
                if (n4 >= this.start.length) continue;
                cPStringBuilder.append(this.toString(n4));
                continue;
            }
            cPStringBuilder.append(string.charAt(n));
        }
        if (n < string.length()) {
            cPStringBuilder.append(string.charAt(n));
        }
        return cPStringBuilder.toString();
    }
}

