/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ZoneInfo
extends TimeZone {
    private static final int SECS_SHIFT = 22;
    private static final long OFFSET_MASK = 0x1FFFFFL;
    private static final int OFFSET_SHIFT = 43;
    private static final long IS_DST = 0x200000L;
    private int rawOffset;
    private int dstSavings;
    private boolean useDaylight;
    private long[] transitions;
    private SimpleTimeZone lastRule;
    private static SimpleTimeZone gmtZone = null;
    static final long serialVersionUID = -3740626706860383657L;

    public ZoneInfo(int n, String string, long[] lArray, SimpleTimeZone simpleTimeZone) {
        if (lArray == null || lArray.length < 1) {
            throw new IllegalArgumentException("transitions must not be null");
        }
        if (simpleTimeZone == null) {
            throw new IllegalArgumentException("lastRule must not be null");
        }
        this.rawOffset = n;
        this.transitions = lArray;
        this.lastRule = simpleTimeZone;
        this.setID(string);
        this.computeDSTSavings();
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        if (gmtZone == null) {
            gmtZone = new SimpleTimeZone(0, "GMT");
        }
        if (n5 < 1 || n5 > 7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (n3 < 0 || n3 > 11) {
            throw new IllegalArgumentException("month out of range:" + n3);
        }
        if (n != 1) {
            return (int)((this.transitions[0] << 43 >> 43) * 1000L);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(gmtZone);
        gregorianCalendar.set(n2, n3, n4, 0, 0, 0);
        if (gregorianCalendar.get(5) != n4) {
            throw new IllegalArgumentException("day out of range");
        }
        return this.getOffset(gregorianCalendar.getTimeInMillis() - (long)this.rawOffset + (long)n6);
    }

    private long findTransition(long l) {
        if (l < this.transitions[0] >> 22) {
            return this.transitions[0];
        }
        if (l >= this.transitions[this.transitions.length - 1] >> 22) {
            return Long.MAX_VALUE;
        }
        long l2 = l + 1L << 22;
        int n = 1;
        int n2 = this.transitions.length;
        int n3 = 1;
        while (n < n2) {
            n3 = (n + n2) / 2;
            if (l2 <= this.transitions[n3 - 1]) {
                n2 = n3;
                continue;
            }
            if (l2 <= this.transitions[n3]) break;
            n = n3 + 1;
        }
        return this.transitions[n3];
    }

    public int getOffset(long l) {
        long l2 = l >= 0L ? l / 1000L : (l + 1L) / 1000L - 1L;
        long l3 = this.findTransition(l2);
        if (l3 == Long.MAX_VALUE) {
            return this.lastRule.getOffset(l);
        }
        return (int)((l3 << 43 >> 43) * 1000L);
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
        this.lastRule.setRawOffset(n);
    }

    private void computeDSTSavings() {
        if (this.lastRule.useDaylightTime()) {
            this.dstSavings = this.lastRule.getDSTSavings();
            this.useDaylight = true;
        } else {
            this.dstSavings = 0;
            this.useDaylight = false;
            long l = System.currentTimeMillis() / 1000L;
            for (int i = this.transitions.length - 1; i >= 0 && l < this.transitions[i] >> 22; --i) {
                if ((this.transitions[i] & 0x200000L) == 0L) continue;
                this.dstSavings = (int)((this.transitions[i] << 43 >> 43) * 1000L) - this.rawOffset;
                this.useDaylight = true;
                break;
            }
        }
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        long l = date.getTime();
        l = l >= 0L ? l / 1000L : (l + 1L) / 1000L - 1L;
        long l2 = this.findTransition(l);
        if (l2 == Long.MAX_VALUE) {
            return this.lastRule.inDaylightTime(date);
        }
        return (l2 & 0x200000L) != 0L;
    }

    public synchronized int hashCode() {
        int n = this.lastRule.hashCode();
        return n;
    }

    public synchronized boolean equals(Object object) {
        if (!this.hasSameRules((TimeZone)object)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)object;
        return this.getID().equals(zoneInfo.getID());
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)timeZone;
        if (zoneInfo.hashCode() != this.hashCode() || this.rawOffset != zoneInfo.rawOffset) {
            return false;
        }
        return this.lastRule.equals(zoneInfo.lastRule);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",transitions=" + this.transitions.length + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",dstSavings=" + this.dstSavings : "") + ",lastRule=" + this.lastRule.toString() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TimeZone readTZFile(String var0, String var1_1) {
        block92: {
            block91: {
                block90: {
                    block89: {
                        block88: {
                            block87: {
                                block86: {
                                    block85: {
                                        block84: {
                                            var2_2 = null;
                                            try {
                                                try {
                                                    block93: {
                                                        var3_3 = new FileInputStream(var1_1);
                                                        var4_5 = new BufferedInputStream(var3_3);
                                                        var2_2 = new DataInputStream(var4_5);
                                                        var5_7 = new byte[5];
                                                        var2_2.readFully(var5_7);
                                                        var6_8 = 4;
                                                        if (var5_7[0] == 84 && var5_7[1] == 90 && var5_7[2] == 105 && var5_7[3] == 102) {
                                                            if (var5_7[4] >= 50) {
                                                                var6_8 = 8;
                                                            }
                                                            ZoneInfo.skipFully(var2_2, 15L);
                                                        } else {
                                                            ZoneInfo.skipFully(var2_2, 11L);
                                                        }
                                                        var7_9 = var2_2.readInt();
                                                        var8_10 = var2_2.readInt();
                                                        var9_11 = var2_2.readInt();
                                                        var10_12 = var2_2.readInt();
                                                        var11_13 = var2_2.readInt();
                                                        var12_14 = var2_2.readInt();
                                                        if (var6_8 == 8) {
                                                            ZoneInfo.skipFully(var2_2, var10_12 * 5 + var11_13 * 6 + var12_14 + var9_11 * 8 + var7_9 + var8_10);
                                                            var2_2.readFully(var5_7);
                                                            if (var5_7[0] != 84 || var5_7[1] != 90 || var5_7[2] != 105 || var5_7[3] != 102 || var5_7[4] < 50) {
                                                                var13_15 = null;
                                                                var44_18 = null;
                                                                break block84;
                                                            }
                                                            ZoneInfo.skipFully(var2_2, 15L);
                                                            var7_9 = var2_2.readInt();
                                                            var8_10 = var2_2.readInt();
                                                            var9_11 = var2_2.readInt();
                                                            var10_12 = var2_2.readInt();
                                                            var11_13 = var2_2.readInt();
                                                            var12_14 = var2_2.readInt();
                                                        }
                                                        if (var11_13 <= 0 || var10_12 < 0 || var12_14 < 0 || var9_11 < 0 || var7_9 < 0 || var8_10 < 0 || var7_9 > var11_13 || var8_10 > var11_13) {
                                                            var13_16 = null;
                                                            break block85;
                                                        }
                                                        var13_17 = new long[var10_12];
                                                        for (var14_40 = 0; var14_40 < var10_12; ++var14_40) {
                                                            var13_17[var14_40] = var6_8 == 8 ? var2_2.readLong() : (long)var2_2.readInt();
                                                        }
                                                        var14_41 = new int[var10_12];
                                                        for (var15_42 = 0; var15_42 < var10_12; ++var15_42) {
                                                            var14_41[var15_42] = var2_2.readByte();
                                                            if (var14_41[var15_42] < 0) {
                                                                v0 = var15_42;
                                                                var14_41[v0] = var14_41[v0] + 256;
                                                            }
                                                            if (var14_41[var15_42] < var11_13) continue;
                                                            var16_44 = null;
                                                            break block86;
                                                        }
                                                        var15_43 = new int[var11_13];
                                                        var16_45 = new int[var11_13];
                                                        for (var17_46 = 0; var17_46 < var11_13; ++var17_46) {
                                                            var15_43[var17_46] = var2_2.readInt();
                                                            if ((long)var15_43[var17_46] >= 0x100000L || (long)var15_43[var17_46] <= -1048576L) {
                                                                var18_49 = null;
                                                                break block87;
                                                            }
                                                            var18_48 = var2_2.readByte();
                                                            var19_51 = var2_2.readByte();
                                                            if (var19_51 < 0) {
                                                                var19_51 += 256;
                                                            }
                                                            if (var19_51 >= var12_14) {
                                                                var20_52 = null;
                                                                break block88;
                                                            }
                                                            var16_45[var17_46] = (var18_48 != 0 ? 256 : 0) + var19_51;
                                                        }
                                                        var17_47 = new byte[var12_14];
                                                        var2_2.readFully(var17_47);
                                                        ZoneInfo.skipFully(var2_2, var9_11 * (var6_8 + 4) + var8_10 + var7_9);
                                                        var18_50 = null;
                                                        if (var6_8 == 8 && var2_2.readByte() == 10 && (var18_50 = var2_2.readLine()).length() <= 0) {
                                                            var18_50 = null;
                                                        }
                                                        var19_51 = -1;
                                                        var20_53 = -1;
                                                        if (var10_12 == 0) {
                                                            var19_51 = 0;
                                                        } else {
                                                            for (var21_54 = var10_12 - 1; var21_54 >= 0; --var21_54) {
                                                                if (var19_51 == -1 && (var16_45[var14_41[var21_54]] & 256) == 0) {
                                                                    var19_51 = var14_41[var21_54];
                                                                } else if (var20_53 == -1 && (var16_45[var14_41[var21_54]] & 256) != 0) {
                                                                    var20_53 = var14_41[var21_54];
                                                                }
                                                                if (var20_53 != -1 && var19_51 != -1) break;
                                                            }
                                                        }
                                                        if (var19_51 == -1) {
                                                            var21_55 = null;
                                                            break block89;
                                                        }
                                                        for (var21_54 = var16_45[var19_51] & 255; var21_54 < var12_14 && var17_47[var21_54] != 0; ++var21_54) {
                                                        }
                                                        var22_56 = new String(var17_47, var16_45[var19_51] & 255, var21_54 - (var16_45[var19_51] & 255), "ASCII");
                                                        var23_57 = "";
                                                        if (var20_53 != -1) {
                                                            for (var21_54 = var16_45[var20_53] & 255; var21_54 < var12_14 && var17_47[var21_54] != 0; ++var21_54) {
                                                            }
                                                            var23_57 = new String(var17_47, var16_45[var20_53] & 255, var21_54 - (var16_45[var20_53] & 255), "ASCII");
                                                        }
                                                        var24_58 = "";
                                                        var25_59 = "";
                                                        if (var18_50 == null && (var20_53 != -1 || var15_43[var19_51] != 0 && !var22_56.startsWith("GMT+") && !var22_56.startsWith("GMT-"))) {
                                                            var24_58 = Integer.toString(-var15_43[var19_51] / 3600);
                                                            var26_60 = -var15_43[var19_51] % 3600;
                                                            if (var26_60 != 0) {
                                                                if (var26_60 < 0) {
                                                                    var26_60 *= -1;
                                                                }
                                                                var24_58 = var26_60 < 600 ? var24_58 + ":0" + Integer.toString(var26_60 / 60) : var24_58 + ":" + Integer.toString(var26_60 / 60);
                                                                if ((var26_60 %= 60) >= 10) {
                                                                    var24_58 = var24_58 + ":" + Integer.toString(var26_60);
                                                                } else if (var26_60 > 0) {
                                                                    var24_58 = var24_58 + ":0" + Integer.toString(var26_60);
                                                                }
                                                            }
                                                            if (var20_53 != -1 && var15_43[var20_53] != var15_43[var19_51] + 3600) {
                                                                var25_59 = Integer.toString(-var15_43[var20_53] / 3600);
                                                                var26_60 = -var15_43[var20_53] % 3600;
                                                                if (var26_60 != 0) {
                                                                    if (var26_60 < 0) {
                                                                        var26_60 *= -1;
                                                                    }
                                                                    var25_59 = var26_60 < 600 ? var25_59 + ":0" + Integer.toString(var26_60 / 60) : var25_59 + ":" + Integer.toString(var26_60 / 60);
                                                                    if ((var26_60 %= 60) >= 10) {
                                                                        var25_59 = var25_59 + ":" + Integer.toString(var26_60);
                                                                    } else if (var26_60 > 0) {
                                                                        var25_59 = var25_59 + ":0" + Integer.toString(var26_60);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        var26_61 = new String[]{null, null};
                                                        if (var18_50 != null || var20_53 == -1 || var10_12 <= 10) break block93;
                                                        var27_62 = System.currentTimeMillis() / 1000L + 157680000L;
                                                        for (var29_65 = var10_12 - 1; var29_65 >= 0 && var13_17[var29_65] >= var27_62 && (var14_41[var29_65] == var19_51 || var14_41[var29_65] == var20_53) && var14_41[var29_65] == var14_41[var10_12 - 2 + ((var29_65 ^ var10_12) & 1)]; --var29_65) {
                                                        }
                                                        if (var10_12 - ++var29_65 < 10 || var14_41[var10_12 - 1] == var14_41[var10_12 - 2]) break block93;
                                                        var30_66 = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
                                                        var31_67 = new int[22];
                                                        for (var32_68 = var10_12 - 1; var32_68 >= var29_65; --var32_68) {
                                                            block96: {
                                                                block94: {
                                                                    block95: {
                                                                        var33_69 = var32_68 % 2 * 11;
                                                                        var34_71 = var15_43[var14_41[var32_68 > var29_65 ? var32_68 - 1 : var32_68 + 1]];
                                                                        var30_66.setTimeInMillis((var13_17[var32_68] + (long)var34_71) * 1000L);
                                                                        if (var32_68 >= var10_12 - 2) {
                                                                            var31_67[var33_69 + 0] = var30_66.get(1);
                                                                            var31_67[var33_69 + 1] = var30_66.get(2);
                                                                            var31_67[var33_69 + 2] = var30_66.get(5);
                                                                            var31_67[var33_69 + 3] = var30_66.getActualMaximum(5);
                                                                            var31_67[var33_69 + 4] = var30_66.get(7);
                                                                            var31_67[var33_69 + 5] = var30_66.get(11);
                                                                            var31_67[var33_69 + 6] = var30_66.get(12);
                                                                            var31_67[var33_69 + 7] = var30_66.get(13);
                                                                            var31_67[var33_69 + 8] = var31_67[var33_69 + 2];
                                                                            var31_67[var33_69 + 9] = var31_67[var33_69 + 2];
                                                                            var31_67[var33_69 + 10] = 0;
                                                                            continue;
                                                                        }
                                                                        var35_74 = var30_66.get(1);
                                                                        var36_75 = var30_66.get(2);
                                                                        var37_76 = var30_66.get(5);
                                                                        var38_77 = var30_66.getActualMaximum(5);
                                                                        var39_78 = var30_66.get(7);
                                                                        var40_79 = var30_66.get(11);
                                                                        var41_80 = var30_66.get(12);
                                                                        var42_81 = var30_66.get(13);
                                                                        if (var35_74 != var31_67[var33_69 + 0] - 1 || var36_75 != var31_67[var33_69 + 1] || var40_79 != var31_67[var33_69 + 5] || var41_80 != var31_67[var33_69 + 6] || var42_81 != var31_67[var33_69 + 7]) break;
                                                                        if (var39_78 != var31_67[var33_69 + 4]) break block94;
                                                                        if (var37_76 < var31_67[var33_69 + 8]) {
                                                                            var31_67[var33_69 + 8] = var37_76;
                                                                        }
                                                                        if (var37_76 > var31_67[var33_69 + 9]) {
                                                                            var31_67[var33_69 + 9] = var37_76;
                                                                        }
                                                                        if (var31_67[var33_69 + 10] < 0) break;
                                                                        if (var31_67[var33_69 + 10] == 0) {
                                                                            var31_67[var33_69 + 10] = 1;
                                                                            if (var31_67[var33_69 + 2] > 28) {
                                                                                var31_67[var33_69 + 2] = 3;
                                                                            } else if (var31_67[var33_69 + 2] <= var31_67[var33_69 + 3] - 7) {
                                                                                var31_67[var33_69 + 3] = 2;
                                                                            }
                                                                        }
                                                                        if (var31_67[var33_69 + 10] != 1) break block95;
                                                                        if (var37_76 > 28) {
                                                                            var31_67[var33_69 + 10] = 3;
                                                                            break block96;
                                                                        } else if (var37_76 <= var38_77 - 7) {
                                                                            var31_67[var33_69 + 10] = 2;
                                                                        }
                                                                        break block96;
                                                                    }
                                                                    if (var31_67[var33_69 + 10] == 2 && var37_76 > 28 || var31_67[var33_69 + 10] == 3 && var37_76 <= var38_77 - 7) {
                                                                        break;
                                                                    }
                                                                    break block96;
                                                                }
                                                                if (var37_76 != var31_67[var33_69 + 2] || var31_67[var33_69 + 10] > 0) break;
                                                                var31_67[var33_69 + 4] = var39_78;
                                                                var31_67[var33_69 + 10] = -1;
                                                            }
                                                            v1 = var33_69 + 0;
                                                            var31_67[v1] = var31_67[v1] - 1;
                                                        }
                                                        if (var32_68 < var29_65) {
                                                            for (var32_68 = 0; var32_68 < 2; ++var32_68) {
                                                                var33_69 = 11 * var32_68;
                                                                if (var31_67[var33_69 + 10] == 0) continue;
                                                                if (var31_67[var33_69 + 10] == -1) {
                                                                    var34_72 = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
                                                                    var35_74 = var34_72[var31_67[var33_69 + 1] - 0];
                                                                    var26_61[var32_68] = ",J" + Integer.toString(var35_74 += var31_67[var33_69 + 2]);
                                                                } else if (var31_67[var33_69 + 10] == 2) {
                                                                    if (var31_67[var33_69 + 8] + 6 != var31_67[var33_69 + 9]) continue;
                                                                    var34_71 = var31_67[var33_69 + 1] - 0 + 1;
                                                                    if (var31_67[var33_69 + 8] % 7 == 1) {
                                                                        var26_61[var32_68] = ",M" + Integer.toString(var34_71);
                                                                        var34_71 = (var31_67[var33_69 + 8] + 6) / 7;
                                                                    } else {
                                                                        var26_61[var32_68] = ",A" + Integer.toString(var34_71);
                                                                        var34_71 = var31_67[var33_69 + 8];
                                                                    }
                                                                    v2 = var32_68;
                                                                    var26_61[v2] = var26_61[v2] + "." + Integer.toString(var34_71);
                                                                    var34_71 = var31_67[var33_69 + 4] - 1;
                                                                    v3 = var32_68;
                                                                    var26_61[v3] = var26_61[v3] + "." + Integer.toString(var34_71);
                                                                } else {
                                                                    if (var31_67[var33_69 + 10] == 1 && var31_67[var33_69 + 1] != 1) continue;
                                                                    var34_71 = var31_67[var33_69 + 1] - 0 + 1;
                                                                    var26_61[var32_68] = ",M" + Integer.toString(var34_71);
                                                                    var34_71 = var31_67[var33_69 + 4] - 1;
                                                                    v4 = var32_68;
                                                                    var26_61[v4] = var26_61[v4] + ".5." + Integer.toString(var34_71);
                                                                }
                                                                if (var31_67[var33_69 + 5] == 2 && var31_67[var33_69 + 6] == 0 && var31_67[var33_69 + 7] == 0) continue;
                                                                var34_73 = var31_67[var33_69 + 5];
                                                                v5 = var32_68;
                                                                var26_61[v5] = var26_61[v5] + "/" + Integer.toString(var34_73);
                                                                if (var31_67[var33_69 + 6] == 0 && var31_67[var33_69 + 7] == 0) continue;
                                                                var34_73 = var31_67[var33_69 + 6];
                                                                if (var34_73 < 10) {
                                                                    v6 = var32_68;
                                                                    var26_61[v6] = var26_61[v6] + ":0" + Integer.toString(var34_73);
                                                                } else {
                                                                    v7 = var32_68;
                                                                    var26_61[v7] = var26_61[v7] + ":" + Integer.toString(var34_73);
                                                                }
                                                                var34_73 = var31_67[var33_69 + 7];
                                                                if (var34_73 >= 10) {
                                                                    v8 = var32_68;
                                                                    var26_61[v8] = var26_61[v8] + ":" + Integer.toString(var34_73);
                                                                    continue;
                                                                }
                                                                if (var34_73 <= 0) continue;
                                                                v9 = var32_68;
                                                                var26_61[v9] = var26_61[v9] + ":0" + Integer.toString(var34_73);
                                                            }
                                                            if (var14_41[var10_12 - 1 & -2] == var19_51) {
                                                                var33_70 = var26_61[0];
                                                                var26_61[0] = var26_61[1];
                                                                var26_61[1] = var33_70;
                                                            }
                                                        }
                                                    }
                                                    if (var18_50 == null) {
                                                        var18_50 = var22_56 + var24_58;
                                                        if (var26_61[0] != null && var26_61[1] != null) {
                                                            var18_50 = var18_50 + var23_57 + var25_59 + var26_61[0] + var26_61[1];
                                                        }
                                                    }
                                                    if (var10_12 == 0) {
                                                        var27_63 = new SimpleTimeZone(var15_43[var19_51] * 1000, var0 != null ? var0 : var18_50);
                                                        break block90;
                                                    }
                                                    var27_64 = ZoneInfo.createLastRule(var18_50);
                                                    if (var27_64 == null) {
                                                        var28_82 = null;
                                                        break block91;
                                                    }
                                                    for (var28_83 = 0; var28_83 < var11_13; ++var28_83) {
                                                        if ((var16_45[var28_83] & 256) != 0) continue;
                                                        var13_17[0] = var13_17[0] << 22 | (long)var15_43[var28_83] & 0x1FFFFFL;
                                                        break;
                                                    }
                                                    for (var28_83 = 1; var28_83 < var10_12; ++var28_83) {
                                                        var13_17[var28_83] = var13_17[var28_83] << 22 | (long)var15_43[var14_41[var28_83 - 1]] & 0x1FFFFFL | ((var16_45[var14_41[var28_83 - 1]] & 256) != 0 ? 0x200000L : 0L);
                                                    }
                                                    var28_84 = new ZoneInfo(var15_43[var19_51] * 1000, var0 != null ? var0 : var18_50, var13_17, var27_64);
                                                    break block92;
                                                }
                                                catch (IOException var3_4) {
                                                    var4_6 = null;
                                                    var44_27 = null;
                                                    try {
                                                        if (var2_2 == null) return var4_6;
                                                        var2_2.close();
                                                        return var4_6;
                                                    }
                                                    catch (IOException var45_38) {
                                                        // empty catch block
                                                    }
                                                    return var4_6;
                                                }
                                            }
                                            catch (Throwable var43_85) {
                                                var44_28 = null;
                                                try {}
                                                catch (IOException var45_39) {
                                                    throw var43_85;
                                                }
                                                if (var2_2 == null) throw var43_85;
                                                var2_2.close();
                                                throw var43_85;
                                            }
                                        }
                                        ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl297:
                                        // 1 sources

                                        if (var2_2 == null) return var13_15;
                                        var2_2.close();
                                        return var13_15;
lbl300:
                                        // 1 sources

                                        catch (IOException var45_29) {
                                            // empty catch block
                                        }
                                        return var13_15;
                                    }
                                    var44_19 = null;
                                    ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl306:
                                    // 1 sources

                                    if (var2_2 == null) return var13_16;
                                    var2_2.close();
                                    return var13_16;
lbl309:
                                    // 1 sources

                                    catch (IOException var45_30) {
                                        // empty catch block
                                    }
                                    return var13_16;
                                }
                                var44_20 = null;
                                ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl315:
                                // 1 sources

                                if (var2_2 == null) return var16_44;
                                var2_2.close();
                                return var16_44;
lbl318:
                                // 1 sources

                                catch (IOException var45_31) {
                                    // empty catch block
                                }
                                return var16_44;
                            }
                            var44_21 = null;
                            ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl324:
                            // 1 sources

                            if (var2_2 == null) return var18_49;
                            var2_2.close();
                            return var18_49;
lbl327:
                            // 1 sources

                            catch (IOException var45_32) {
                                // empty catch block
                            }
                            return var18_49;
                        }
                        var44_22 = null;
                        ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl333:
                        // 1 sources

                        if (var2_2 == null) return var20_52;
                        var2_2.close();
                        return var20_52;
lbl336:
                        // 1 sources

                        catch (IOException var45_33) {
                            // empty catch block
                        }
                        return var20_52;
                    }
                    var44_23 = null;
                    ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl342:
                    // 1 sources

                    if (var2_2 == null) return var21_55;
                    var2_2.close();
                    return var21_55;
lbl345:
                    // 1 sources

                    catch (IOException var45_34) {
                        // empty catch block
                    }
                    return var21_55;
                }
                var44_24 = null;
                ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl351:
                // 1 sources

                if (var2_2 == null) return var27_63;
                var2_2.close();
                return var27_63;
lbl354:
                // 1 sources

                catch (IOException var45_35) {
                    // empty catch block
                }
                return var27_63;
            }
            var44_25 = null;
            ** try [egrp 2[TRYBLOCK] [20 : 3396->3407)] { 
lbl360:
            // 1 sources

            if (var2_2 == null) return var28_82;
            var2_2.close();
            return var28_82;
lbl363:
            // 1 sources

            catch (IOException var45_36) {
                // empty catch block
            }
            return var28_82;
        }
        var44_26 = null;
        try {}
        catch (IOException var45_37) {
            // empty catch block
            return var28_84;
        }
        if (var2_2 == null) return var28_84;
        var2_2.close();
        return var28_84;
    }

    private static void skipFully(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 <= 0L) {
                throw new EOFException();
            }
            l -= l2;
        }
    }

    private static SimpleTimeZone createLastRule(String string) {
        String string2 = null;
        try {
            int n;
            char c;
            int n2 = string.length();
            int n3 = 0;
            while ((c = string.charAt(n3)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++n3 < n2) {
            }
            if (n3 >= n2) {
                return new SimpleTimeZone(0, string);
            }
            string2 = string.substring(0, n3);
            int n4 = n3;
            while (((c = string.charAt(n3++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && n3 < n2) {
            }
            if (n3 < n2) {
                --n3;
            }
            String string3 = string.substring(n4, n3);
            n4 = n3;
            int n5 = string3.charAt(0) == '+' || string3.charAt(0) == '-' ? ZoneInfo.parseTime(string3.substring(1)) : ZoneInfo.parseTime(string3);
            if (string3.charAt(0) == '-') {
                n5 = -n5;
            }
            n5 = -n5;
            if (n3 >= n2) {
                return new SimpleTimeZone(n5, string2);
            }
            while ((c = string.charAt(n3)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++n3 < n2) {
            }
            if (n3 >= n2) {
                return new SimpleTimeZone(n5, string2);
            }
            n4 = n3;
            while (((c = string.charAt(n3++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && n3 < n2) {
            }
            if (n3 < n2) {
                --n3;
            }
            if (n3 == n4 && (c == ',' || c == ';')) {
                n = n5 + 3600000;
            } else {
                string3 = string.substring(n4, n3);
                n4 = n3;
                n = string3.charAt(0) == '+' || string3.charAt(0) == '-' ? ZoneInfo.parseTime(string3.substring(1)) : ZoneInfo.parseTime(string3);
                if (string3.charAt(0) == '-') {
                    n = -n;
                }
                n = -n;
            }
            if (n3 >= n2) {
                return new SimpleTimeZone(n5, string2);
            }
            if (string.charAt(n3) == ',' || string.charAt(n3) == ';') {
                int n6;
                String string4;
                int n7;
                String string5;
                int n8 = ++n3;
                while (string.charAt(n3) != ',' && string.charAt(n3) != ';') {
                    ++n3;
                }
                String string6 = string.substring(n8, n3);
                String string7 = string.substring(++n3);
                n3 = string6.indexOf(47);
                if (n3 != -1) {
                    string5 = string6.substring(0, n3);
                    n7 = ZoneInfo.parseTime(string6.substring(n3 + 1));
                } else {
                    string5 = string6;
                    n7 = 0x6DDD00;
                }
                n3 = string7.indexOf(47);
                if (n3 != -1) {
                    string4 = string7.substring(0, n3);
                    n6 = ZoneInfo.parseTime(string7.substring(n3 + 1));
                } else {
                    string4 = string7;
                    n6 = 0x6DDD00;
                }
                int[] nArray = ZoneInfo.getDateParams(string5);
                int[] nArray2 = ZoneInfo.getDateParams(string4);
                return new SimpleTimeZone(n5, string, nArray[0], nArray[1], nArray[2], n7, nArray2[0], nArray2[1], nArray2[2], n6, n - n5);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static int[] getDateParams(String string) {
        int n;
        int n2;
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int n3 = 0;
        if (string.charAt(0) == 'M' || string.charAt(0) == 'm') {
            n3 = 1;
        } else if (string.charAt(0) == 'A' || string.charAt(0) == 'a') {
            n3 = 2;
        }
        if (n3 > 0) {
            int n4;
            int n5 = Integer.parseInt(string.substring(1, string.indexOf(46)));
            int n6 = Integer.parseInt(string.substring(string.indexOf(46) + 1, string.lastIndexOf(46)));
            int n7 = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
            ++n7;
            if (n3 == 2) {
                n4 = n6;
                n7 = -n7;
            } else if (n6 == 5) {
                n4 = -1;
            } else {
                n4 = (n6 - 1) * 7 + 1;
                n7 = -n7;
            }
            return new int[]{--n5, n4, n7};
        }
        if (string.charAt(0) != 'J' || string.charAt(0) != 'j') {
            n2 = Integer.parseInt(string.substring(1));
            ++n2;
            nArray = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        } else {
            n2 = Integer.parseInt(string);
        }
        for (n = 11; n > 0 && nArray[n] >= n2; --n) {
        }
        int n8 = n;
        return new int[]{n8, n2 -= nArray[n], 0};
    }

    private static int parseTime(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) != ':'; ++n) {
        }
        n2 = 3600000 * Integer.parseInt(string.substring(0, n));
        if (n >= string.length()) {
            return n2;
        }
        int n3 = ++n;
        while (n < string.length() && string.charAt(n) != ':') {
            ++n;
        }
        n2 += 60000 * Integer.parseInt(string.substring(n3, n));
        if (n >= string.length()) {
            return n2;
        }
        return n2 += 1000 * Integer.parseInt(string.substring(++n));
    }
}

