/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FormatCharacterIterator
implements AttributedCharacterIterator {
    private String formattedString;
    private int charIndex;
    private int attributeIndex;
    private int[] ranges;
    private HashMap[] attributes;
    private static final boolean DEBUG = false;

    public FormatCharacterIterator() {
        this.formattedString = "";
        this.ranges = new int[0];
        this.attributes = new HashMap[0];
    }

    public FormatCharacterIterator(String string, int[] nArray, HashMap[] hashMapArray) {
        this.formattedString = string;
        this.ranges = nArray;
        this.attributes = hashMapArray;
    }

    public Set getAllAttributeKeys() {
        if (this.attributes != null && this.attributes[this.attributeIndex] != null) {
            return this.attributes[this.attributeIndex].keySet();
        }
        return new HashSet();
    }

    public Map getAttributes() {
        if (this.attributes != null && this.attributes[this.attributeIndex] != null) {
            return this.attributes[this.attributeIndex];
        }
        return new HashMap();
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        if (this.attributes != null && this.attributes[this.attributeIndex] != null) {
            return this.attributes[this.attributeIndex].get(attribute);
        }
        return null;
    }

    public int getRunLimit(Set set) {
        Set set2;
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        int n = this.attributeIndex;
        do {
            if (++n != this.attributes.length) continue;
            return this.formattedString.length();
        } while (this.attributes[n] != null && (set2 = this.attributes[n].keySet()).containsAll(set));
        return this.ranges[n - 1];
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        HashSet hashSet = new HashSet();
        hashSet.add(attribute);
        return this.getRunLimit((Set)hashSet);
    }

    public int getRunLimit() {
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        if (this.attributes[this.attributeIndex] == null) {
            for (int i = this.attributeIndex + 1; i < this.attributes.length; ++i) {
                if (this.attributes[i] == null) continue;
                return this.ranges[i - 1];
            }
            return this.formattedString.length();
        }
        return this.getRunLimit(this.attributes[this.attributeIndex].keySet());
    }

    public int getRunStart(Set set) {
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        int n = this.attributeIndex;
        Set set2 = null;
        do {
            if (n != 0) continue;
            return 0;
        } while (this.attributes[--n] != null && (set2 = this.attributes[n].keySet()).containsAll(set));
        return n > 0 ? this.ranges[n - 1] : 0;
    }

    public int getRunStart() {
        if (this.attributes == null) {
            return 0;
        }
        if (this.attributes[this.attributeIndex] == null) {
            for (int i = this.attributeIndex; i > 0; --i) {
                if (this.attributes[i] == null) continue;
                return this.ranges[this.attributeIndex - 1];
            }
            return 0;
        }
        return this.getRunStart(this.attributes[this.attributeIndex].keySet());
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        HashSet hashSet = new HashSet();
        hashSet.add(attribute);
        return this.getRunStart((Set)hashSet);
    }

    public Object clone() {
        return new FormatCharacterIterator(this.formattedString, this.ranges, this.attributes);
    }

    public char current() {
        return this.formattedString.charAt(this.charIndex);
    }

    public char first() {
        this.charIndex = 0;
        this.attributeIndex = 0;
        return this.formattedString.charAt(0);
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.formattedString.length();
    }

    public int getIndex() {
        return this.charIndex;
    }

    public char last() {
        this.charIndex = this.formattedString.length() - 1;
        if (this.attributes != null) {
            this.attributeIndex = this.attributes.length - 1;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public char next() {
        ++this.charIndex;
        if (this.charIndex >= this.formattedString.length()) {
            this.charIndex = this.getEndIndex();
            return '\uffff';
        }
        if (this.attributes != null && this.charIndex >= this.ranges[this.attributeIndex]) {
            ++this.attributeIndex;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public char previous() {
        --this.charIndex;
        if (this.charIndex < 0) {
            this.charIndex = 0;
            return '\uffff';
        }
        if (this.attributes != null && this.charIndex < this.ranges[this.attributeIndex]) {
            --this.attributeIndex;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public char setIndex(int n) {
        if (n < 0 || n > this.formattedString.length()) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.charIndex = n;
        if (this.attributes != null) {
            this.attributeIndex = 0;
            while (this.attributeIndex < this.attributes.length && this.ranges[this.attributeIndex] <= this.charIndex) {
                ++this.attributeIndex;
            }
            --this.attributeIndex;
        }
        if (this.charIndex == this.formattedString.length()) {
            return '\uffff';
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public void mergeAttributes(HashMap[] hashMapArray, int[] nArray) {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<HashMap> vector2 = new Vector<HashMap>();
        int n = 0;
        int n2 = 0;
        this.debug("merging " + hashMapArray.length + " attrs");
        while (n < this.ranges.length && n2 < nArray.length) {
            if (this.attributes[n] != null) {
                vector2.add(this.attributes[n]);
                if (hashMapArray[n2] != null) {
                    this.attributes[n].putAll(hashMapArray[n2]);
                }
            } else {
                vector2.add(hashMapArray[n2]);
            }
            if (this.ranges[n] == nArray[n2]) {
                vector.add(new Integer(nArray[n2]));
                ++n;
                ++n2;
                continue;
            }
            if (this.ranges[n] < nArray[n2]) {
                vector.add(new Integer(this.ranges[n]));
                ++n;
                continue;
            }
            vector.add(new Integer(nArray[n2]));
            ++n2;
        }
        if (n != this.ranges.length) {
            while (n < this.ranges.length) {
                vector2.add(this.attributes[n]);
                vector.add(new Integer(this.ranges[n]));
                ++n;
            }
        }
        if (n2 != nArray.length) {
            while (n2 < nArray.length) {
                vector2.add(hashMapArray[n2]);
                vector.add(new Integer(nArray[n2]));
                ++n2;
            }
        }
        this.attributes = new HashMap[vector2.size()];
        this.ranges = new int[vector.size()];
        System.arraycopy(vector2.toArray(), 0, this.attributes, 0, this.attributes.length);
        for (n = 0; n < vector.size(); ++n) {
            this.ranges[n] = (Integer)vector.elementAt(n);
        }
        this.dumpTable();
    }

    public void append(AttributedCharacterIterator attributedCharacterIterator) {
        char c = attributedCharacterIterator.first();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Map<AttributedCharacterIterator.Attribute, Object>> vector2 = new Vector<Map<AttributedCharacterIterator.Attribute, Object>>();
        do {
            this.formattedString = this.formattedString + String.valueOf(c);
            vector2.add(attributedCharacterIterator.getAttributes());
            vector.add(new Integer(this.formattedString.length()));
        } while ((c = attributedCharacterIterator.next()) != '\uffff');
        HashMap[] hashMapArray = new HashMap[this.attributes.length + vector2.size()];
        int[] nArray = new int[this.ranges.length + vector.size()];
        System.arraycopy(this.attributes, 0, hashMapArray, 0, this.attributes.length);
        System.arraycopy(vector2.toArray(), 0, hashMapArray, this.attributes.length, vector2.size());
        System.arraycopy(this.ranges, 0, nArray, 0, this.ranges.length);
        Object[] objectArray = vector.toArray();
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i + this.ranges.length] = (Integer)objectArray[i];
        }
        this.attributes = hashMapArray;
        this.ranges = nArray;
    }

    public void append(String string, HashMap hashMap) {
        int[] nArray = new int[this.ranges.length + 1];
        HashMap[] hashMapArray = new HashMap[this.attributes.length + 1];
        this.formattedString = this.formattedString + string;
        System.arraycopy(this.attributes, 0, hashMapArray, 0, this.attributes.length);
        System.arraycopy(this.ranges, 0, nArray, 0, this.ranges.length);
        nArray[this.ranges.length] = this.formattedString.length();
        hashMapArray[this.attributes.length] = hashMap;
        this.ranges = nArray;
        this.attributes = hashMapArray;
    }

    public void append(String string) {
        this.append(string, null);
    }

    public void addAttributes(HashMap hashMap, int n, int n2) {
        if (n == 0) {
            this.mergeAttributes(new HashMap[]{hashMap}, new int[]{n2});
        } else {
            this.mergeAttributes(new HashMap[]{null, hashMap}, new int[]{n, n2});
        }
    }

    private void debug(String string) {
    }

    private void dumpTable() {
        boolean bl = false;
    }
}

