/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.lang.CPStringBuilder;
import gnu.java.text.FormatBuffer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;

public class AttributedFormatBuffer
implements FormatBuffer {
    private final CPStringBuilder buffer;
    private final ArrayList ranges;
    private final ArrayList attributes;
    private int[] a_ranges;
    private HashMap[] a_attributes;
    private int startingRange;
    AttributedCharacterIterator.Attribute defaultAttr;

    public AttributedFormatBuffer(CPStringBuilder cPStringBuilder) {
        this.buffer = new CPStringBuilder(cPStringBuilder);
        this.ranges = new ArrayList();
        this.attributes = new ArrayList();
        this.defaultAttr = null;
        if (cPStringBuilder.length() != 0) {
            this.startingRange = cPStringBuilder.length();
            this.addAttribute(cPStringBuilder.length(), null);
        } else {
            this.startingRange = -1;
        }
    }

    public AttributedFormatBuffer(int n) {
        this(new CPStringBuilder(n));
    }

    public AttributedFormatBuffer() {
        this(10);
    }

    private final void addAttribute(int n, AttributedCharacterIterator.Attribute attribute) {
        if (attribute != null) {
            HashMap<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute> hashMap = new HashMap<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute>();
            hashMap.put(attribute, attribute);
            this.attributes.add(hashMap);
        } else {
            this.attributes.add(null);
        }
        this.ranges.add(new Integer(n));
    }

    public void append(String string) {
        if (this.startingRange < 0) {
            this.startingRange = 0;
        }
        this.buffer.append(string);
    }

    public void append(String string, AttributedCharacterIterator.Attribute attribute) {
        this.setDefaultAttribute(attribute);
        this.startingRange = this.buffer.length();
        this.append(string);
        this.setDefaultAttribute(null);
    }

    public void append(String string, int[] nArray, HashMap[] hashMapArray) {
        int n = this.buffer.length();
        this.setDefaultAttribute(null);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.ranges.add(new Integer(nArray[i] + n));
                this.attributes.add(hashMapArray[i]);
            }
        }
        this.startingRange = this.buffer.length();
        this.buffer.append(string);
    }

    public void append(char c) {
        if (this.startingRange < 0) {
            this.startingRange = this.buffer.length();
        }
        this.buffer.append(c);
    }

    public void append(char c, AttributedCharacterIterator.Attribute attribute) {
        this.setDefaultAttribute(attribute);
        this.buffer.append(c);
        this.setDefaultAttribute(null);
    }

    public void setDefaultAttribute(AttributedCharacterIterator.Attribute attribute) {
        if (attribute == this.defaultAttr) {
            return;
        }
        int n = this.buffer.length();
        if (this.startingRange != n && this.startingRange >= 0) {
            this.addAttribute(n, this.defaultAttr);
        }
        this.defaultAttr = attribute;
        this.startingRange = n;
    }

    public AttributedCharacterIterator.Attribute getDefaultAttribute() {
        return this.defaultAttr;
    }

    public void cutTail(int n) {
        this.buffer.setLength(this.buffer.length() - n);
    }

    public int length() {
        return this.buffer.length();
    }

    public void clear() {
        this.buffer.setLength(0);
        this.ranges.clear();
        this.attributes.clear();
        this.defaultAttr = null;
        this.startingRange = -1;
    }

    public void sync() {
        if (this.startingRange < 0 || this.startingRange == this.buffer.length()) {
            return;
        }
        this.addAttribute(this.buffer.length(), this.defaultAttr);
        this.a_ranges = new int[this.ranges.size()];
        for (int i = 0; i < this.a_ranges.length; ++i) {
            this.a_ranges[i] = (Integer)this.ranges.get(i);
        }
        this.a_attributes = new HashMap[this.attributes.size()];
        System.arraycopy(this.attributes.toArray(), 0, this.a_attributes, 0, this.a_attributes.length);
    }

    public CPStringBuilder getBuffer() {
        return this.buffer;
    }

    public int[] getRanges() {
        return this.a_ranges;
    }

    public HashMap[] getAttributes() {
        return this.a_attributes;
    }
}

