/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;

public class ReasonCode
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.21");
    public final int reason;

    public ReasonCode(byte[] byArray) throws IOException {
        super(byArray);
        DERValue dERValue = DERReader.read(byArray);
        if (dERValue.getTag() != 10) {
            throw new IOException("malformed CRLReason");
        }
        this.reason = ((BigInteger)dERValue.getValue()).intValue();
        if (this.reason < 0 || this.reason == 7 || this.reason > 10) {
            throw new IOException("illegal reason: " + this.reason);
        }
    }

    public int getReasonCode() {
        return this.reason;
    }

    public String toString() {
        return ReasonCode.class.getName() + " [ " + this.reason + " ]";
    }
}

