/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.GeneralName;
import java.io.IOException;
import java.math.BigInteger;

public class GeneralSubtree {
    private final GeneralName base;
    private final int minimum;
    private final int maximum;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralSubtree(byte[] byArray) throws IOException {
        int n;
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed GeneralSubtree");
        }
        DERValue dERValue2 = dERReader.read();
        this.base = new GeneralName(dERValue2.getEncoded());
        if (dERValue2.isConstructed()) {
            dERReader.skip(dERValue2.getLength());
        }
        if ((n = dERValue2.getEncodedLength()) < dERValue.getLength()) {
            DERValue dERValue3 = dERReader.read();
            if (dERValue3.getTag() == 0) {
                this.minimum = ((BigInteger)dERValue3.getValue()).intValue();
                if ((n += dERValue3.getEncodedLength()) < dERValue.getLength()) {
                    dERValue3 = dERReader.read();
                    if (dERValue3.getTag() != 1) {
                        throw new IOException("unexpected tag " + dERValue3.getTag() + " (expected 1 for GeneralSubtree maximum distance)");
                    }
                    this.maximum = ((BigInteger)dERValue3.getValue()).intValue();
                    return;
                } else {
                    this.maximum = -1;
                }
                return;
            } else {
                if (dERValue3.getTag() != 1) throw new IOException("unexpected tag " + dERValue3.getTag() + " (expected 0 or 1 for GeneralSubtree distance)");
                this.minimum = 1;
                this.maximum = ((BigInteger)dERValue3.getValue()).intValue();
            }
            return;
        } else {
            this.minimum = 0;
            this.maximum = -1;
        }
    }

    public GeneralName base() {
        return this.base;
    }

    public int minimum() {
        return this.minimum;
    }

    public int maximum() {
        return this.maximum;
    }

    public String toString() {
        return GeneralSubtree.class.getName() + " [ base=" + this.base + "; minimum=" + this.minimum + "; maximim=" + this.maximum + " ]";
    }
}

