/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import java.io.IOException;
import java.util.Arrays;

public class GeneralName {
    private final Kind kind;
    private final byte[] name;
    private final byte[] encoded;

    public GeneralName(byte[] byArray) throws IOException {
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (dERValue.getTagClass() != 128) {
            throw new IOException("malformed GeneralName");
        }
        this.encoded = dERValue.getEncoded();
        this.kind = Kind.forTag(dERValue.getTag());
        switch (this.kind) {
            case otherName: {
                this.name = dERValue.getEncoded();
                this.name[0] = 48;
                dERReader.read();
                dERReader.read();
                break;
            }
            case rfc822Name: {
                this.name = (byte[])dERValue.getValue();
                break;
            }
            case dNSName: {
                this.name = (byte[])dERValue.getValue();
                break;
            }
            case x400Address: {
                this.name = (byte[])dERValue.getValue();
                break;
            }
            case directoryName: {
                this.name = dERValue.getEncoded();
                this.name[0] = 48;
                break;
            }
            case ediPartyName: {
                this.name = dERValue.getEncoded();
                this.name[0] = 48;
                break;
            }
            case uniformResourceIdentifier: {
                this.name = (byte[])dERValue.getValue();
                break;
            }
            case iPAddress: {
                this.name = (byte[])dERValue.getValue();
                break;
            }
            case registeredId: {
                this.name = dERValue.getEncoded();
                this.name[0] = 6;
                break;
            }
            default: {
                this.name = null;
            }
        }
    }

    public GeneralName(Kind kind, byte[] byArray) {
        this.kind = kind;
        this.name = (byte[])byArray.clone();
        this.encoded = null;
    }

    public Kind kind() {
        return this.kind;
    }

    public byte[] name() {
        return (byte[])this.name.clone();
    }

    public byte[] encoded() {
        try {
            return (byte[])this.encoded.clone();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        try {
            GeneralName generalName = (GeneralName)object;
            return generalName.kind() == this.kind() && Arrays.equals(this.name, generalName.name);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return super.toString() + " [ kind=" + (Object)((Object)this.kind) + "; name=" + Util.hexDump(this.name, "") + " ]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        otherName(0),
        rfc822Name(1),
        dNSName(2),
        x400Address(3),
        directoryName(4),
        ediPartyName(5),
        uniformResourceIdentifier(6),
        iPAddress(7),
        registeredId(8);

        private int tag;

        private Kind(int n2) {
            this.tag = n2;
        }

        public static Kind forTag(int n) {
            switch (n) {
                case 0: {
                    return otherName;
                }
                case 1: {
                    return rfc822Name;
                }
                case 2: {
                    return dNSName;
                }
                case 3: {
                    return x400Address;
                }
                case 4: {
                    return directoryName;
                }
                case 5: {
                    return ediPartyName;
                }
                case 6: {
                    return uniformResourceIdentifier;
                }
                case 7: {
                    return iPAddress;
                }
                case 8: {
                    return registeredId;
                }
            }
            throw new IllegalArgumentException("invalid tag: " + n);
        }

        public int tag() {
            return this.tag;
        }
    }
}

