/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

public class BasicConstraints
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.19");
    private final boolean ca;
    private final int pathLenConstraint;

    public BasicConstraints(byte[] byArray) throws IOException {
        super(byArray);
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed BasicConstraints");
        }
        DERValue dERValue2 = dERValue;
        if (dERValue.getLength() > 0) {
            dERValue2 = dERReader.read();
        }
        if (dERValue2.getTag() == 1) {
            this.ca = (Boolean)dERValue2.getValue();
            if (dERValue2.getEncodedLength() < dERValue.getLength()) {
                dERValue2 = dERReader.read();
            }
        } else {
            this.ca = false;
        }
        this.pathLenConstraint = dERValue2.getTag() == 2 ? ((BigInteger)dERValue2.getValue()).intValue() : -1;
    }

    public BasicConstraints(boolean bl, int n) {
        this.ca = bl;
        this.pathLenConstraint = n;
    }

    public boolean isCA() {
        return this.ca;
    }

    public int getPathLengthConstraint() {
        return this.pathLenConstraint;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList<DERValue> arrayList = new ArrayList<DERValue>(2);
            arrayList.add(new DERValue(1, this.ca));
            if (this.pathLenConstraint >= 0) {
                arrayList.add(new DERValue(2, BigInteger.valueOf(this.pathLenConstraint)));
            }
            this.encoded = new DERValue(48, arrayList).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return BasicConstraints.class.getName() + " [ isCA=" + this.ca + " pathLen=" + this.pathLenConstraint + " ]";
    }
}

