/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.x509.X500DistinguishedName;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CertSelectorImpl
implements CertSelector {
    private Set issuerNames = new HashSet();
    private Set subjectNames = new HashSet();

    public void addIssuerName(byte[] byArray) throws IOException {
        this.issuerNames.add(new X500DistinguishedName(byArray));
    }

    public void addIssuerName(String string) {
        this.issuerNames.add(new X500DistinguishedName(string));
    }

    public void addIssuerName(Principal principal) throws IOException {
        if (principal instanceof X500DistinguishedName) {
            this.issuerNames.add(principal);
        } else if (principal instanceof X500Principal) {
            this.issuerNames.add(new X500DistinguishedName(((X500Principal)principal).getEncoded()));
        } else {
            this.issuerNames.add(new X500DistinguishedName(principal.getName()));
        }
    }

    public Collection getIssuerNames() {
        return Collections.unmodifiableSet(this.issuerNames);
    }

    public void addSubjectName(byte[] byArray) throws IOException {
        this.subjectNames.add(new X500DistinguishedName(byArray));
    }

    public void addSubjectName(String string) throws IOException {
        this.subjectNames.add(new X500DistinguishedName(string));
    }

    public void addSubjectName(Principal principal) throws IOException {
        if (principal instanceof X500DistinguishedName) {
            this.subjectNames.add(principal);
        } else if (principal instanceof X500Principal) {
            this.subjectNames.add(new X500DistinguishedName(((X500Principal)principal).getEncoded()));
        } else {
            this.subjectNames.add(new X500DistinguishedName(principal.getName()));
        }
    }

    public Collection getSubjectNames() {
        return Collections.unmodifiableSet(this.subjectNames);
    }

    public Object clone() {
        X509CertSelectorImpl x509CertSelectorImpl = new X509CertSelectorImpl();
        x509CertSelectorImpl.issuerNames.addAll(this.issuerNames);
        x509CertSelectorImpl.subjectNames.addAll(this.subjectNames);
        return x509CertSelectorImpl;
    }

    public boolean match(Certificate certificate) {
        boolean bl;
        boolean bl2;
        block8: {
            if (!(certificate instanceof X509Certificate)) {
                return false;
            }
            bl2 = false;
            bl = false;
            try {
                Principal principal = ((X509Certificate)certificate).getIssuerDN();
                X500DistinguishedName x500DistinguishedName = null;
                x500DistinguishedName = principal instanceof X500DistinguishedName ? (X500DistinguishedName)principal : (principal instanceof X500Principal ? new X500DistinguishedName(((X500Principal)principal).getEncoded()) : new X500DistinguishedName(principal.getName()));
                if (this.issuerNames.isEmpty()) {
                    bl2 = true;
                } else {
                    for (X500DistinguishedName x500DistinguishedName2 : this.issuerNames) {
                        if (!x500DistinguishedName.equals(x500DistinguishedName2)) continue;
                        bl2 = true;
                        break;
                    }
                }
                principal = ((X509Certificate)certificate).getSubjectDN();
                x500DistinguishedName = null;
                x500DistinguishedName = principal instanceof X500DistinguishedName ? (X500DistinguishedName)principal : (principal instanceof X500Principal ? new X500DistinguishedName(((X500Principal)principal).getEncoded()) : new X500DistinguishedName(principal.getName()));
                if (this.subjectNames.isEmpty()) {
                    bl = true;
                    break block8;
                }
                for (X500DistinguishedName x500DistinguishedName2 : this.subjectNames) {
                    if (!x500DistinguishedName.equals(x500DistinguishedName2)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2 && bl;
    }
}

