/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;

    public ByteBufferOutputStream() {
        this(256);
    }

    public ByteBufferOutputStream(int n) {
        this.buffer = ByteBuffer.allocate(n);
    }

    public synchronized void write(int n) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.growBuffer();
        }
        this.buffer.put((byte)n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (this.buffer.remaining() < n2) {
            this.growBuffer();
        }
        this.buffer.put(byArray, n, n2);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().flip()).slice();
    }

    public String toString() {
        return super.toString() + " [ buffer: " + this.buffer + " ]";
    }

    private void growBuffer() {
        int n = this.buffer.capacity();
        n = n < 16384 ? (n <<= 1) : (n += 4096);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.buffer.flip();
        byteBuffer.put(this.buffer);
        this.buffer = byteBuffer;
    }
}

